/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.model;

import java.util.Date;
import java.util.TimeZone;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;

public class MessageCommitInfo
extends CommitInfo {
    public static final String MERGE_MESSAGE = "Merge branch '%s'";
    public static final String REVERT_MERGE_MESSAGE = "Revert merge from branch '%s'";
    public static final String FIX_REVERT_MERGE_MESSAGE = "Fix after merge reversion";

    public MessageCommitInfo(String message) {
        this(null, null, null, message, null, null);
    }

    private MessageCommitInfo(String sessionId, String name, String email, String message, TimeZone timeZone, Date when) {
        super(sessionId, name, email, message, timeZone, when);
    }

    public static MessageCommitInfo createMergeMessage(String sourceBranch) {
        return new MessageCommitInfo(String.format(MERGE_MESSAGE, sourceBranch));
    }

    public static MessageCommitInfo createRevertMergeMessage(String sourceBranch) {
        return new MessageCommitInfo(String.format(REVERT_MERGE_MESSAGE, sourceBranch));
    }

    public static MessageCommitInfo createFixMergeReversionMessage() {
        return new MessageCommitInfo(FIX_REVERT_MERGE_MESSAGE);
    }
}

