/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.BackendUserSystemManager;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.RoleManager;
import org.uberfire.ext.security.management.api.RoleManagerSettings;
import org.uberfire.ext.security.management.api.exception.NoImplementationAvailableException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.service.RoleManagerService;

@Service
@ApplicationScoped
public class RoleManagerServiceImpl
implements RoleManagerService {
    private static final Logger LOG = LoggerFactory.getLogger(RoleManagerServiceImpl.class);
    @Inject
    private BackendUserSystemManager userSystemManager;
    private RoleManager service;

    @PostConstruct
    public void init() {
        this.service = this.userSystemManager.roles();
    }

    private RoleManager getService() throws SecurityManagementException {
        if (this.service == null) {
            throw new NoImplementationAvailableException();
        }
        return this.service;
    }

    public AbstractEntityManager.SearchResponse<Role> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        RoleManager serviceImpl = this.getService();
        if (request.getPage() == 0) {
            throw new IllegalArgumentException("First page must be 1.");
        }
        return serviceImpl.search(request);
    }

    public Role get(String identifier) throws SecurityManagementException {
        RoleManager serviceImpl = this.getService();
        return (Role)serviceImpl.get(identifier);
    }

    public List<Role> getAll() throws SecurityManagementException {
        RoleManager serviceImpl = this.getService();
        return serviceImpl.getAll();
    }

    public Role create(Role entity) throws SecurityManagementException {
        RoleManager serviceImpl = this.getService();
        return (Role)serviceImpl.create((Object)entity);
    }

    public Role update(Role entity) throws SecurityManagementException {
        RoleManager serviceImpl = this.getService();
        return (Role)serviceImpl.update((Object)entity);
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        RoleManager serviceImpl = this.getService();
        serviceImpl.delete(identifiers);
    }

    public RoleManagerSettings getSettings() {
        RoleManager serviceImpl = this.getService();
        return (RoleManagerSettings)serviceImpl.getSettings();
    }
}

