/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.metamodel;

import java.util.Set;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.model.schema.MetaProperty;

public class ElasticMetaProperty
implements MetaProperty {
    private String name;
    private String value;
    private boolean sortable;
    private boolean searchable;
    private Set<Class<?>> types;

    public ElasticMetaProperty(String name, String value, Set<Class<?>> types) {
        this(name, value, types, false, false);
    }

    public ElasticMetaProperty(String name, String value, Set<Class<?>> types, boolean sortable, boolean searchable) {
        this.name = PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        this.value = value;
        this.types = (Set)PortablePreconditions.checkNotNull((String)"types", types);
        this.sortable = sortable;
        this.searchable = searchable;
    }

    public String getName() {
        return this.name;
    }

    public Set<Class<?>> getTypes() {
        return this.types;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void setAsSearchable() {
        this.searchable = true;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setAsSortable() {
        this.sortable = true;
    }

    public void addType(Class<?> aClass) {
        this.types.add(aClass);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isBoolean() {
        return this.getTypes().contains(Boolean.class);
    }
}

