/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl;

import java.util.ArrayList;
import java.util.List;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

public class LayoutHelper {
    private int maxColumns = 12;
    private List<List<LayoutComponent>> grid = new ArrayList<List<LayoutComponent>>();
    private List<LayoutComponent> currentRow;

    public LayoutHelper() {
        this.addRow();
    }

    public LayoutHelper(int maxColumns) {
        this();
        if (1 > maxColumns || maxColumns > 12) {
            throw new IllegalArgumentException("Invalid maxColums value (" + maxColumns + ") value should be between 1 - 12");
        }
        this.maxColumns = maxColumns;
    }

    public LayoutHelper newRow() {
        if (!this.currentRow.isEmpty()) {
            this.addRow();
        }
        return this;
    }

    private void addRow() {
        this.currentRow = new ArrayList<LayoutComponent>();
        this.grid.add(this.currentRow);
    }

    public LayoutHelper add(LayoutComponent layoutComponent) {
        if (this.currentRow.size() == this.maxColumns) {
            this.newRow();
        }
        this.currentRow.add(layoutComponent);
        return this;
    }

    public LayoutTemplate build() {
        LayoutTemplate layoutTemplate = new LayoutTemplate();
        this.grid.forEach(row -> layoutTemplate.addRow(this.build((List<LayoutComponent>)row)));
        return layoutTemplate;
    }

    private LayoutRow build(List<LayoutComponent> components) {
        LayoutRow row = new LayoutRow();
        int columns = components.size();
        if (columns > 0) {
            int span = Math.floorDiv(this.maxColumns, columns);
            CountDown countDown = new CountDown(this.maxColumns % columns);
            components.forEach(layoutComponent -> {
                int columnSpan = span;
                if (countDown.hasValue()) {
                    ++columnSpan;
                }
                LayoutColumn column = new LayoutColumn(String.valueOf(columnSpan));
                column.add(layoutComponent);
                row.add(column);
            });
        }
        return row;
    }

    private class CountDown {
        private int value;

        public CountDown(int value) {
            this.value = value;
        }

        public boolean hasValue() {
            return 0 < this.value--;
        }
    }
}

