/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.response;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringRuleNamePageRow;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.paging.PageResponse;

public class RuleNameResponseBuilder
implements ResponseBuilder {
    @Override
    public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
        int hits = kObjects.size();
        PageResponse response = new PageResponse();
        List<RefactoringPageRow> result = this.buildResponse(kObjects);
        response.setTotalRowSize(hits);
        response.setPageRowList(result);
        response.setTotalRowSizeExact(true);
        response.setStartRowIndex(startRow);
        response.setLastPage(pageSize * startRow + 2 >= hits);
        return response;
    }

    @Override
    public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
        ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
        HashSet<RefactoringRuleNamePageRow.RuleName> uniqueRuleNames = new HashSet<RefactoringRuleNamePageRow.RuleName>();
        for (KObject kObject : kObjects) {
            Set<RefactoringRuleNamePageRow.RuleName> ruleNames = this.getRuleNamesFromKObject(kObject);
            uniqueRuleNames.addAll(ruleNames);
        }
        for (RefactoringRuleNamePageRow.RuleName ruleName : uniqueRuleNames) {
            RefactoringRuleNamePageRow row = new RefactoringRuleNamePageRow();
            row.setValue((Object)ruleName);
            result.add((RefactoringPageRow)row);
        }
        return result;
    }

    private Set<RefactoringRuleNamePageRow.RuleName> getRuleNamesFromKObject(KObject kObject) {
        HashSet<RefactoringRuleNamePageRow.RuleName> ruleNames = new HashSet<RefactoringRuleNamePageRow.RuleName>();
        if (kObject == null) {
            return ruleNames;
        }
        Set kProperties = StreamSupport.stream(kObject.getProperties().spliterator(), false).collect(Collectors.toSet());
        Optional<KProperty> packageName = kProperties.stream().filter(kp -> kp.getName().equals("packageName")).findFirst();
        packageName.flatMap(pkg -> Optional.of(pkg.getValue().toString())).ifPresent(pkgName -> kProperties.stream().filter(kp -> kp.getName().equals(ResourceType.RULE.toString())).forEach(r -> ruleNames.add(new RefactoringRuleNamePageRow.RuleName(r.getValue().toString().replace((CharSequence)pkgName, "").replaceFirst("\\.", ""), pkgName))));
        return ruleNames;
    }
}

