/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.FileDetailsResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryFileExtensionIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryValueFileNameIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryValueRepositoryRootIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindAllLibraryAssetsQuery
extends AbstractFindQuery
implements NamedQuery {
    public static String NAME = "FindAllLibraryAssetsQuery";
    @Inject
    private FileDetailsResponseBuilder responseBuilder;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms) {
        this.checkNotNullAndNotEmpty(terms);
        Query query = this.buildFromMultipleTerms(terms);
        return query;
    }

    @Override
    public Sort getSortOrder() {
        return new Sort(new SortField("filenamesorted", SortField.Type.STRING));
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    @Override
    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{"libraryRepositoryRoot", null, null}, t -> t instanceof LibraryValueRepositoryRootIndexTerm, t -> t instanceof LibraryValueFileNameIndexTerm, t -> t instanceof LibraryFileExtensionIndexTerm);
        this.checkTermsSize(3, queryTerms);
    }
}

