/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SearchEmptyQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringStringPageRow;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class FindPackageNamesQuery
extends AbstractFindQuery
implements NamedQuery {
    public static final String NAME = FindPackageNamesQuery.class.getSimpleName();
    private static final ValuePackageNameIndexTerm packageNameIndexTerm = new ValuePackageNameIndexTerm();
    private PackageResponseBuilder responseBuilder = new PackageResponseBuilder();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms) {
        SearchEmptyQueryBuilder queryBuilder = new SearchEmptyQueryBuilder();
        for (ValueIndexTerm term : terms) {
            if (term instanceof ValueModuleRootPathIndexTerm) {
                queryBuilder.addTerm(term);
                continue;
            }
            if (!(term instanceof ValuePackageNameIndexTerm)) continue;
            if (Objects.equals("*", term.getValue())) {
                queryBuilder.addAnyValueWildCardTerm(term);
                continue;
            }
            queryBuilder.addTerm(term);
        }
        return queryBuilder.build();
    }

    @Override
    public void validateTerms(Set<ValueIndexTerm> queryTerms) {
        this.checkNotNullAndNotEmpty(queryTerms);
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{null, packageNameIndexTerm.getTerm()}, t -> t instanceof ValueModuleRootPathIndexTerm, t -> Objects.equals(t.getTerm(), packageNameIndexTerm.getTerm()));
    }

    private static class PackageResponseBuilder
    implements ResponseBuilder {
        private PackageResponseBuilder() {
        }

        @Override
        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            throw new UnsupportedOperationException("Paged response is not supported.");
        }

        @Override
        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            for (KObject kObject : kObjects) {
                for (String name : this.getPackageNamesFromKObject(kObject)) {
                    RefactoringStringPageRow row = new RefactoringStringPageRow();
                    row.setValue((Object)name);
                    result.add((RefactoringPageRow)row);
                }
            }
            return result;
        }

        private Set<String> getPackageNamesFromKObject(KObject kObject) {
            HashSet<String> result = new HashSet<String>();
            if (kObject == null) {
                return result;
            }
            for (KProperty property : kObject.getProperties()) {
                if (!Objects.equals("packageName", property.getName())) continue;
                result.add(property.getValue().toString());
            }
            return result;
        }
    }
}

