/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueBranchNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringMapPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class FindRuleFlowNamesQuery
extends AbstractFindQuery
implements NamedQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindRuleFlowNamesQuery.class);
    private final IOService ioService;
    private RuleFlowNamesResponseBuilder responseBuilder = new RuleFlowNamesResponseBuilder();
    public static final String NAME = FindRuleFlowNamesQuery.class.getSimpleName();
    public static final String SHARED_TERM = "shared:" + PartType.RULEFLOW_GROUP.toString();
    private static final ValueSharedPartIndexTerm ruleFlowTerm = new ValueSharedPartIndexTerm("not-used", PartType.RULEFLOW_GROUP);

    @Inject
    public FindRuleFlowNamesQuery(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = ioService;
    }

    public static boolean isSharedRuleFlowGroup(String parameter) {
        return SHARED_TERM.equals(parameter);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        this.responseBuilder.setIOService(this.ioService);
        return this.responseBuilder;
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms) {
        return this.buildFromSingleTerm(terms);
    }

    @Override
    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkNotNullAndNotEmpty(queryTerms);
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{null, null, ruleFlowTerm.getTerm()}, t -> t instanceof ValueModuleNameIndexTerm, t -> t instanceof ValueBranchNameIndexTerm, t -> t.getTerm().equals(ruleFlowTerm.getTerm()));
    }

    private static class RuleFlowNamesResponseBuilder
    implements ResponseBuilder {
        private IOService ioService;

        private RuleFlowNamesResponseBuilder() {
        }

        public void setIOService(IOService ioService) {
            this.ioService = ioService;
        }

        @Override
        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        @Override
        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            for (KObject kObject : kObjects) {
                List<Map<String, String>> ruleFlowGroups = this.getRuleFlowGroupsFromKObject(kObject);
                for (Map<String, String> group : ruleFlowGroups) {
                    RefactoringMapPageRow row = new RefactoringMapPageRow();
                    row.setValue(group);
                    result.add((RefactoringPageRow)row);
                }
            }
            return result;
        }

        private List<Map<String, String>> getRuleFlowGroupsFromKObject(KObject kObject) {
            ArrayList<Map<String, String>> ruleFlowGroups = new ArrayList<Map<String, String>>();
            if (kObject == null) {
                return ruleFlowGroups;
            }
            for (KProperty property : kObject.getProperties()) {
                org.uberfire.backend.vfs.Path path;
                if (!SHARED_TERM.equals(property.getName()) || (path = this.getPath(kObject)) == null) continue;
                HashMap<String, String> group = new HashMap<String, String>();
                group.put("name", property.getValue().toString());
                group.put("filename", path.getFileName());
                group.put("pathuri", path.toURI());
                ruleFlowGroups.add(group);
            }
            return ruleFlowGroups;
        }

        private org.uberfire.backend.vfs.Path getPath(KObject kObject) {
            try {
                return Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
            }
            catch (FileSystemNotFoundException ex) {
                LOGGER.error(ex.toString());
                return null;
            }
        }
    }
}

