/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.guvnor.common.services.backend.metadata.MetadataBuilder;
import org.guvnor.common.services.backend.metadata.attribute.DiscussionView;
import org.guvnor.common.services.backend.metadata.attribute.GeneratedAttributesView;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaView;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

public class MetadataCreator {
    private final Path path;
    private final DublinCoreView dublinCoreView;
    private final DiscussionView discussView;
    private final OtherMetaView otherMetaView;
    private final VersionAttributeView versionAttributeView;
    private final GeneratedAttributesView generatedAttributesView;
    private final IOService configIOService;
    private final SessionInfo sessionInfo;

    public MetadataCreator(Path path, IOService configIOService, SessionInfo sessionInfo, DublinCoreView dublinCoreView, DiscussionView discussionView, OtherMetaView otherMetaView, VersionAttributeView versionAttributeView, GeneratedAttributesView generatedAttributesView) {
        this.path = (Path)PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.configIOService = (IOService)PortablePreconditions.checkNotNull((String)"configIOService", (Object)configIOService);
        this.sessionInfo = (SessionInfo)PortablePreconditions.checkNotNull((String)"sessionInfo", (Object)sessionInfo);
        this.dublinCoreView = (DublinCoreView)PortablePreconditions.checkNotNull((String)"dublinCoreView", (Object)dublinCoreView);
        this.discussView = (DiscussionView)((Object)PortablePreconditions.checkNotNull((String)"discussionView", (Object)((Object)discussionView)));
        this.otherMetaView = (OtherMetaView)((Object)PortablePreconditions.checkNotNull((String)"otherMetaView", (Object)((Object)otherMetaView)));
        this.versionAttributeView = (VersionAttributeView)PortablePreconditions.checkNotNull((String)"versionAttributeView", (Object)versionAttributeView);
        this.generatedAttributesView = (GeneratedAttributesView)((Object)PortablePreconditions.checkNotNull((String)"generatedAttributesView", (Object)((Object)generatedAttributesView)));
    }

    public Metadata create() {
        return MetadataBuilder.newMetadata().withPath(Paths.convert((Path)this.path)).withRealPath(Paths.convert((Path)this.path.toRealPath(new LinkOption[0]))).withCheckinComment(this.getCheckinComment()).withLastContributor(this.getLastContributor()).withCreator(this.getCreator()).withLastModified(this.getLastModified()).withDateCreated(this.getDateCreated()).withSubject(this.getSubject()).withType(this.getType()).withExternalRelation(this.getExternalRelation()).withExternalSource(this.getExternalSource()).withDescription(this.getDescription()).withTags(this.getTags()).withDiscussion(this.getDiscussion()).withLockInfo(this.retrieveLockInfo(Paths.convert((Path)this.path))).withVersion(this.getVersion()).withGenerated(this.getGenerated()).build();
    }

    private ArrayList<VersionRecord> getVersion() {
        return new ArrayList<VersionRecord>(this.versionAttributeView.readAttributes().history().records().size()){
            {
                for (VersionRecord record : MetadataCreator.this.versionAttributeView.readAttributes().history().records()) {
                    this.add(new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
                }
            }
        };
    }

    private boolean getGenerated() {
        return this.generatedAttributesView.readAttributes().isGenerated();
    }

    private List<DiscussionRecord> getDiscussion() {
        return this.discussView.readAttributes().discussion();
    }

    private List<String> getTags() {
        return this.otherMetaView.readAttributes().tags();
    }

    private String getDescription() {
        return this.dublinCoreView.readAttributes().descriptions().size() > 0 ? (String)this.dublinCoreView.readAttributes().descriptions().get(0) : null;
    }

    private String getExternalSource() {
        return this.dublinCoreView.readAttributes().sources().size() > 0 ? (String)this.dublinCoreView.readAttributes().sources().get(0) : null;
    }

    private String getExternalRelation() {
        return this.dublinCoreView.readAttributes().relations().size() > 0 ? (String)this.dublinCoreView.readAttributes().relations().get(0) : null;
    }

    private String getType() {
        return this.dublinCoreView.readAttributes().types().size() > 0 ? (String)this.dublinCoreView.readAttributes().types().get(0) : null;
    }

    private String getSubject() {
        return this.dublinCoreView.readAttributes().subjects().size() > 0 ? (String)this.dublinCoreView.readAttributes().subjects().get(0) : null;
    }

    private Date getDateCreated() {
        return new Date(this.versionAttributeView.readAttributes().creationTime().toMillis());
    }

    private Date getLastModified() {
        return new Date(this.versionAttributeView.readAttributes().lastModifiedTime().toMillis());
    }

    private String getCreator() {
        if (this.versionAttributeView.readAttributes().history().records().size() > 0) {
            return ((VersionRecord)this.versionAttributeView.readAttributes().history().records().get(0)).author();
        }
        return null;
    }

    private String getLastContributor() {
        if (this.versionAttributeView.readAttributes().history().records().size() > 0) {
            return ((VersionRecord)this.versionAttributeView.readAttributes().history().records().get(this.versionAttributeView.readAttributes().history().records().size() - 1)).author();
        }
        return null;
    }

    private String getCheckinComment() {
        VersionAttributes versionAttributes = this.versionAttributeView.readAttributes();
        VersionHistory history = versionAttributes.history();
        List records = history.records();
        if (records.size() > 0) {
            return ((VersionRecord)this.versionAttributeView.readAttributes().history().records().get(this.versionAttributeView.readAttributes().history().records().size() - 1)).comment();
        }
        return null;
    }

    private LockInfo retrieveLockInfo(org.uberfire.backend.vfs.Path path) {
        Path lockPath = Paths.convert((org.uberfire.backend.vfs.Path)PathFactory.newLock((org.uberfire.backend.vfs.Path)path));
        try {
            String lockedBy = this.configIOService.readAllString(lockPath);
            return new LockInfo(true, lockedBy, path);
        }
        catch (NoSuchFileException nsfe) {
            return new LockInfo(false, "", path);
        }
    }
}

