/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.metadata.engine.IndexerScheduler;
import org.uberfire.ext.metadata.event.IndexEvent;

public class SimpleIndexerScheduler
implements IndexerScheduler {
    private static final Logger logger = LoggerFactory.getLogger(SimpleIndexerScheduler.class);
    private final Map<String, ? extends Supplier<List<IndexEvent>>> jobsById;

    public static IndexerScheduler.Factory factory() {
        return jobsById -> new SimpleIndexerScheduler(jobsById);
    }

    public SimpleIndexerScheduler(Map<String, ? extends Supplier<List<IndexEvent>>> jobsById) {
        this.jobsById = jobsById;
    }

    public Stream<CompletableFuture<Pair<String, List<IndexEvent>>>> schedule(ExecutorService executor) {
        return this.jobsById.entrySet().stream().map(entry -> {
            String indexerId = (String)entry.getKey();
            Supplier job = (Supplier)entry.getValue();
            logger.debug("Scheduling job for indexer [id={}].", (Object)indexerId);
            return CompletableFuture.supplyAsync(job, executor).thenApply(events -> new Pair((Object)indexerId, events));
        });
    }
}

