/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.server.config;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;

public class ConfigGroup {
    private String name;
    private String description;
    private ConfigType type;
    private String namespace;
    private boolean enabled;
    private Map<String, ConfigItem> items = new ConcurrentHashMap<String, ConfigItem>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConfigType getType() {
        return this.type;
    }

    public void setType(ConfigType type) {
        this.type = type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Collection<ConfigItem> getItems() {
        return this.items.values();
    }

    public void addConfigItem(ConfigItem configItem) {
        if (!this.items.containsKey(configItem.getName())) {
            this.setConfigItem(configItem);
        }
    }

    public void setConfigItem(ConfigItem configItem) {
        this.items.put(configItem.getName(), configItem);
    }

    public ConfigItem getConfigItem(String name) {
        return this.items.get(name);
    }

    public void removeConfigItem(String name) {
        this.items.remove(name);
    }

    public String getConfigItemValue(String name) {
        ConfigItem configItem = this.items.get(name);
        if (configItem == null) {
            return null;
        }
        return (String)configItem.getValue();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

