/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

@Dependent
public class RenamePopUpPresenter {
    private static final boolean DEFAULT_DIRTY_STATUS = false;
    private static final String DEFAULT_FILE_NAME = "";
    private static final CommandWithFileNameAndCommitMessage DEFAULT_COMMAND = c -> {};
    private final View view;
    private final ToggleCommentPresenter toggleCommentPresenter;
    private Path path;
    private Validator validator;
    private CommandWithFileNameAndCommitMessage renameCommand;
    private CommandWithFileNameAndCommitMessage saveAndRenameCommand;
    private String originalFileName;
    private boolean isDirty;

    @Inject
    public RenamePopUpPresenter(View view, ToggleCommentPresenter toggleCommentPresenter) {
        this.view = view;
        this.toggleCommentPresenter = toggleCommentPresenter;
    }

    public void show(Path path, Validator validator, CommandWithFileNameAndCommitMessage renameCommand, CommandWithFileNameAndCommitMessage saveAndRenameCommand, boolean isDirty, String originalFileName) {
        this.validator = (Validator)PortablePreconditions.checkNotNull((String)"validator", (Object)validator);
        this.path = (Path)PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.renameCommand = (CommandWithFileNameAndCommitMessage)PortablePreconditions.checkNotNull((String)"renameCommand", (Object)renameCommand);
        this.saveAndRenameCommand = (CommandWithFileNameAndCommitMessage)PortablePreconditions.checkNotNull((String)"saveAndRenameCommand", (Object)saveAndRenameCommand);
        this.originalFileName = (String)PortablePreconditions.checkNotNull((String)"originalFileName", (Object)originalFileName);
        this.isDirty = (Boolean)PortablePreconditions.checkNotNull((String)"isDirty", (Object)isDirty);
        this.setupView();
        this.showView();
    }

    void setupView() {
        this.enablePrimaryButton();
        this.hideSaveAndRenameIfAssetIsNotDirty();
    }

    void showView() {
        this.view.setOriginalFileName(this.getOriginalFileName());
        this.view.show();
    }

    public void show(Path path, CommandWithFileNameAndCommitMessage renameCommand, String originalFileName) {
        Validator validator = this.defaultValidator();
        this.show(path, validator, renameCommand, DEFAULT_COMMAND, false, originalFileName);
    }

    public void show(Path path, Validator validator, CommandWithFileNameAndCommitMessage renameCommand) {
        this.show(path, validator, renameCommand, DEFAULT_COMMAND, false, DEFAULT_FILE_NAME);
    }

    public void show(Path path, Validator validator, boolean isDirty, CommandWithFileNameAndCommitMessage renameCommand, CommandWithFileNameAndCommitMessage saveAndRenameCommand) {
        this.show(path, validator, renameCommand, saveAndRenameCommand, isDirty, DEFAULT_FILE_NAME);
    }

    public void show(Path path, CommandWithFileNameAndCommitMessage renameCommand) {
        Validator validator = this.defaultValidator();
        this.show(path, validator, renameCommand, DEFAULT_COMMAND, false, DEFAULT_FILE_NAME);
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void rename(String newName) {
        String fileName = this.newFileName(newName);
        String comment = this.toggleCommentPresenter.getComment();
        ValidatorWithReasonCallback callback = this.validatorCallback(comment, newName, this.renameCommand);
        this.validator.validate(fileName, callback);
    }

    public void saveAndRename(String newName) {
        String fileName = this.newFileName(newName);
        String comment = this.toggleCommentPresenter.getComment();
        ValidatorWithReasonCallback callback = this.validatorCallback(comment, newName, this.saveAndRenameCommand);
        this.validator.validate(fileName, callback);
    }

    private String newFileName(String newName) {
        String extension = this.extension(this.path.getFileName());
        return newName + extension;
    }

    private String extension(String fileName) {
        return fileName.lastIndexOf(".") > 0 ? fileName.substring(fileName.lastIndexOf(".")) : DEFAULT_FILE_NAME;
    }

    private ValidatorWithReasonCallback validatorCallback(final String comment, final String baseFileName, final CommandWithFileNameAndCommitMessage onSuccess) {
        return new ValidatorWithReasonCallback(){

            @Override
            public void onFailure(String reason) {
                if (ValidationErrorReason.DUPLICATED_NAME.name().equals(reason)) {
                    RenamePopUpPresenter.this.view.handleDuplicatedFileName();
                } else if (ValidationErrorReason.NOT_ALLOWED.name().equals(reason)) {
                    RenamePopUpPresenter.this.view.handleRenameNotAllowed();
                } else {
                    RenamePopUpPresenter.this.view.handleInvalidFileName();
                }
            }

            @Override
            public void onSuccess() {
                onSuccess.execute(new FileNameAndCommitMessage(baseFileName, comment));
            }

            @Override
            public void onFailure() {
                RenamePopUpPresenter.this.view.handleInvalidFileName();
            }
        };
    }

    boolean isDirty() {
        return this.isDirty;
    }

    public void cancel() {
        this.view.hide();
    }

    public View getView() {
        return this.view;
    }

    public ToggleCommentPresenter getToggleCommentPresenter() {
        return this.toggleCommentPresenter;
    }

    private Validator defaultValidator() {
        return (value, callback) -> callback.onSuccess();
    }

    Path getPath() {
        return this.path;
    }

    Validator getValidator() {
        return this.validator;
    }

    CommandWithFileNameAndCommitMessage getRenameCommand() {
        return this.renameCommand;
    }

    String getOriginalFileName() {
        return this.originalFileName;
    }

    void hideSaveAndRenameIfAssetIsNotDirty() {
        this.view.hideSaveAndRename(!this.isDirty());
    }

    void enablePrimaryButton() {
        if (this.isDirty()) {
            this.view.saveAndRenameAsPrimary();
        } else {
            this.view.renameAsPrimary();
        }
    }

    public static interface View
    extends UberElemental<RenamePopUpPresenter> {
        public void show();

        public void hide();

        public void handleDuplicatedFileName();

        public void handleInvalidFileName();

        public void setOriginalFileName(String var1);

        public void handleRenameNotAllowed();

        public void renameAsPrimary();

        public void saveAndRenameAsPrimary();

        public void hideSaveAndRename(boolean var1);
    }
}

