/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.dnd;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.VetoDragException;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.client.mvp.UIPart;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.events.DropPlaceEvent;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.widgets.dnd.CompassWidget;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragContext;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
public class CompassDropController
implements DropController {
    @Inject
    CompassWidget compass;
    WorkbenchPanelView<?> dropTarget;
    @Inject
    PanelManager panelManager;
    @Inject
    WorkbenchDragAndDropManager dndManager;
    @Inject
    private Event<DropPlaceEvent> workbenchPartDroppedEvent;

    public void setup(WorkbenchPanelView<?> view) {
        this.dropTarget = view;
    }

    public void onEnter(DragContext context) {
        this.compass.onEnter(context);
    }

    public void onLeave(DragContext context) {
        this.compass.onLeave(context);
    }

    public void onMove(DragContext context) {
        this.compass.onMove(context);
    }

    public void onDrop(DragContext context) {
        Position p = this.compass.getDropPosition();
        if (p == CompassPosition.NONE) {
            return;
        }
        this.compass.onDrop(context);
        WorkbenchDragContext workbenchContext = this.dndManager.getWorkbenchContext();
        Menus menus = workbenchContext.getMenus();
        PanelDefinition sourcePanel = workbenchContext.getSourcePanel();
        PanelDefinition dropPanel = this.dropTarget.getPresenter().getDefinition();
        if (sourcePanel.equals(dropPanel)) {
            if (sourcePanel.getParts() != null && sourcePanel.getParts().size() == 1) {
                return;
            }
            if (p == CompassPosition.SELF) {
                return;
            }
        }
        PlaceRequest place = workbenchContext.getPlace();
        this.firePartDroppedEvent(place);
        Integer height = null;
        Integer width = null;
        Integer minHeight = workbenchContext.getMinHeight();
        Integer minWidth = workbenchContext.getMinWidth();
        PanelDefinition targetPanel = this.panelManager.addWorkbenchPanel(dropPanel, p, height, width, minHeight, minWidth);
        UIPart uiPart = workbenchContext.getUiPart();
        PartDefinition sourcePart = workbenchContext.getSourcePart();
        this.panelManager.addWorkbenchPart(place, sourcePart, targetPanel, menus, uiPart, workbenchContext.getContextId(), null, null);
    }

    void firePartDroppedEvent(PlaceRequest place) {
        this.workbenchPartDroppedEvent.fire((Object)new DropPlaceEvent(place));
    }

    public Widget getDropTarget() {
        return this.dropTarget.getPartDropRegion();
    }

    public void onPreviewDrop(DragContext context) throws VetoDragException {
    }
}

