/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ParentBulkByScrollTask;
import org.elasticsearch.index.reindex.SuccessfullyProcessed;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.ThreadPool;

public class WorkingBulkByScrollTask
extends BulkByScrollTask
implements SuccessfullyProcessed {
    private static final Logger logger = ESLoggerFactory.getLogger(BulkByScrollTask.class.getPackage().getName());
    private final Integer sliceId;
    private final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong updated = new AtomicLong(0L);
    private final AtomicLong created = new AtomicLong(0L);
    private final AtomicLong deleted = new AtomicLong(0L);
    private final AtomicLong noops = new AtomicLong(0L);
    private final AtomicInteger batch = new AtomicInteger(0);
    private final AtomicLong versionConflicts = new AtomicLong(0L);
    private final AtomicLong bulkRetries = new AtomicLong(0L);
    private final AtomicLong searchRetries = new AtomicLong(0L);
    private final AtomicLong throttledNanos = new AtomicLong();
    private volatile float requestsPerSecond;
    private final AtomicReference<DelayedPrepareBulkRequest> delayedPrepareBulkRequestReference = new AtomicReference();

    public WorkingBulkByScrollTask(long id, String type, String action, String description, TaskId parentTask, Integer sliceId, float requestsPerSecond) {
        super(id, type, action, description, parentTask);
        this.sliceId = sliceId;
        this.setRequestsPerSecond(requestsPerSecond);
    }

    @Override
    public BulkByScrollTask.Status getStatus() {
        return new BulkByScrollTask.Status(this.sliceId, this.total.get(), this.updated.get(), this.created.get(), this.deleted.get(), this.batch.get(), this.versionConflicts.get(), this.noops.get(), this.bulkRetries.get(), this.searchRetries.get(), TimeValue.timeValueNanos(this.throttledNanos.get()), this.getRequestsPerSecond(), this.getReasonCancelled(), this.throttledUntil());
    }

    @Override
    protected void onCancelled() {
        this.rethrottle(Float.POSITIVE_INFINITY);
    }

    @Override
    public int runningSliceSubTasks() {
        return 0;
    }

    @Override
    public TaskInfo getInfoGivenSliceInfo(String localNodeId, List<TaskInfo> sliceInfo) {
        throw new UnsupportedOperationException("This is only supported by " + ParentBulkByScrollTask.class.getName() + ".");
    }

    TimeValue throttledUntil() {
        DelayedPrepareBulkRequest delayed = this.delayedPrepareBulkRequestReference.get();
        if (delayed == null) {
            return TimeValue.timeValueNanos(0L);
        }
        if (delayed.future == null) {
            return TimeValue.timeValueNanos(0L);
        }
        return TimeValue.timeValueNanos(Math.max(0L, delayed.future.getDelay(TimeUnit.NANOSECONDS)));
    }

    public void setTotal(long totalHits) {
        this.total.set(totalHits);
    }

    public void countBatch() {
        this.batch.incrementAndGet();
    }

    public void countNoop() {
        this.noops.incrementAndGet();
    }

    @Override
    public long getCreated() {
        return this.created.get();
    }

    public void countCreated() {
        this.created.incrementAndGet();
    }

    @Override
    public long getUpdated() {
        return this.updated.get();
    }

    public void countUpdated() {
        this.updated.incrementAndGet();
    }

    @Override
    public long getDeleted() {
        return this.deleted.get();
    }

    public void countDeleted() {
        this.deleted.incrementAndGet();
    }

    public void countVersionConflict() {
        this.versionConflicts.incrementAndGet();
    }

    public void countBulkRetry() {
        this.bulkRetries.incrementAndGet();
    }

    public void countSearchRetry() {
        this.searchRetries.incrementAndGet();
    }

    float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayPrepareBulkRequest(ThreadPool threadPool, TimeValue lastBatchStartTime, int lastBatchSize, AbstractRunnable prepareBulkRequestRunnable) {
        AtomicReference<DelayedPrepareBulkRequest> atomicReference = this.delayedPrepareBulkRequestReference;
        synchronized (atomicReference) {
            TimeValue delay = this.throttleWaitTime(lastBatchStartTime, TimeValue.timeValueNanos(System.nanoTime()), lastBatchSize);
            logger.debug("[{}]: preparing bulk request for [{}]", (Object)this.getId(), (Object)delay);
            this.delayedPrepareBulkRequestReference.set(new DelayedPrepareBulkRequest(threadPool, this.getRequestsPerSecond(), delay, new RunOnce(prepareBulkRequestRunnable)));
        }
    }

    public TimeValue throttleWaitTime(TimeValue lastBatchStartTime, TimeValue now, int lastBatchSize) {
        long earliestNextBatchStartTime = now.nanos() + (long)this.perfectlyThrottledBatchTime(lastBatchSize);
        return TimeValue.timeValueNanos(Math.max(0L, earliestNextBatchStartTime - System.nanoTime()));
    }

    float perfectlyThrottledBatchTime(int lastBatchSize) {
        if (this.requestsPerSecond == Float.POSITIVE_INFINITY) {
            return 0.0f;
        }
        float targetBatchTimeInSeconds = (float)lastBatchSize / this.requestsPerSecond;
        return (float)TimeUnit.SECONDS.toNanos(1L) * targetBatchTimeInSeconds;
    }

    private void setRequestsPerSecond(float requestsPerSecond) {
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("requests per second must be more than 0 but was [" + requestsPerSecond + "]");
        }
        this.requestsPerSecond = requestsPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rethrottle(float newRequestsPerSecond) {
        AtomicReference<DelayedPrepareBulkRequest> atomicReference = this.delayedPrepareBulkRequestReference;
        synchronized (atomicReference) {
            logger.debug("[{}]: rethrottling to [{}] requests per second", (Object)this.getId(), (Object)Float.valueOf(newRequestsPerSecond));
            this.setRequestsPerSecond(newRequestsPerSecond);
            DelayedPrepareBulkRequest delayedPrepareBulkRequest = this.delayedPrepareBulkRequestReference.get();
            if (delayedPrepareBulkRequest == null) {
                logger.debug("[{}]: skipping rescheduling because there is no scheduled task", (Object)this.getId());
                return;
            }
            this.delayedPrepareBulkRequestReference.set(delayedPrepareBulkRequest.rethrottle(newRequestsPerSecond));
        }
    }

    private static class RunOnce
    extends AbstractRunnable {
        private final AtomicBoolean hasRun = new AtomicBoolean(false);
        private final AbstractRunnable delegate;

        RunOnce(AbstractRunnable delegate) {
            this.delegate = delegate;
        }

        @Override
        protected void doRun() throws Exception {
            if (this.hasRun.compareAndSet(false, true)) {
                this.delegate.run();
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.delegate.onFailure(e);
        }
    }

    class DelayedPrepareBulkRequest {
        private final ThreadPool threadPool;
        private final AbstractRunnable command;
        private final float requestsPerSecond;
        private final ScheduledFuture<?> future;

        DelayedPrepareBulkRequest(ThreadPool threadPool, float requestsPerSecond, final TimeValue delay, final AbstractRunnable command) {
            this.threadPool = threadPool;
            this.requestsPerSecond = requestsPerSecond;
            this.command = command;
            this.future = threadPool.schedule(delay, "generic", new AbstractRunnable(){

                @Override
                protected void doRun() throws Exception {
                    WorkingBulkByScrollTask.this.throttledNanos.addAndGet(delay.nanos());
                    command.run();
                }

                @Override
                public void onFailure(Exception e) {
                    command.onFailure(e);
                }
            });
        }

        DelayedPrepareBulkRequest rethrottle(float newRequestsPerSecond) {
            if (newRequestsPerSecond < this.requestsPerSecond) {
                logger.debug("[{}]: skipping rescheduling because the new throttle [{}] is slower than the old one [{}]", (Object)WorkingBulkByScrollTask.this.getId(), (Object)Float.valueOf(newRequestsPerSecond), (Object)Float.valueOf(this.requestsPerSecond));
                return this;
            }
            long remainingDelay = this.future.getDelay(TimeUnit.NANOSECONDS);
            if (!FutureUtils.cancel(this.future)) {
                logger.debug("[{}]: skipping rescheduling because we couldn't cancel the task", (Object)WorkingBulkByScrollTask.this.getId());
                return this;
            }
            TimeValue newDelay = this.newDelay(remainingDelay, newRequestsPerSecond);
            logger.debug("[{}]: rescheduling for [{}] in the future", (Object)WorkingBulkByScrollTask.this.getId(), (Object)newDelay);
            return new DelayedPrepareBulkRequest(this.threadPool, this.requestsPerSecond, newDelay, this.command);
        }

        TimeValue newDelay(long remainingDelay, float newRequestsPerSecond) {
            if (remainingDelay < 0L) {
                return TimeValue.timeValueNanos(0L);
            }
            return TimeValue.timeValueNanos(Math.round((float)remainingDelay * this.requestsPerSecond / newRequestsPerSecond));
        }
    }
}

