/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.repositories.blobstore.BlobStoreFormat;

public class ChecksumBlobStoreFormat<T extends ToXContent>
extends BlobStoreFormat<T> {
    private static final String TEMP_FILE_PREFIX = "pending-";
    private static final XContentType DEFAULT_X_CONTENT_TYPE = XContentType.SMILE;
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    protected final XContentType xContentType;
    protected final boolean compress;
    private final String codec;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry, boolean compress, XContentType xContentType) {
        super(blobNameFormat, reader, namedXContentRegistry);
        this.xContentType = xContentType;
        this.compress = compress;
        this.codec = codec;
    }

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry, boolean compress) {
        this(codec, blobNameFormat, reader, namedXContentRegistry, compress, DEFAULT_X_CONTENT_TYPE);
    }

    /*
     * Exception decompiling
     */
    @Override
    public T readBlob(BlobContainer blobContainer, String blobName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeAtomic(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        String tempBlobName = this.tempBlobName(name);
        this.writeBlob(obj, blobContainer, tempBlobName);
        try {
            blobContainer.move(tempBlobName, blobName);
        }
        catch (IOException ex) {
            try {
                blobContainer.deleteBlob(tempBlobName);
            }
            catch (Exception e) {
                ex.addSuppressed(e);
            }
            throw ex;
        }
    }

    public void write(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        this.writeBlob(obj, blobContainer, blobName);
    }

    protected void writeBlob(T obj, BlobContainer blobContainer, String blobName) throws IOException {
        BytesReference bytes = this.write(obj);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String resourceDesc = "ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")";
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput(resourceDesc, blobName, (OutputStream)byteArrayOutputStream, 4096);){
                CodecUtil.writeHeader((DataOutput)indexOutput, (String)this.codec, (int)1);
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream((IndexOutput)indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };){
                    bytes.writeTo(indexOutputOutputStream);
                }
                CodecUtil.writeFooter((IndexOutput)indexOutput);
            }
            BytesArray bytesArray = new BytesArray(byteArrayOutputStream.toByteArray());
            try (StreamInput stream = bytesArray.streamInput();){
                blobContainer.writeBlob(blobName, stream, bytesArray.length());
            }
        }
    }

    public boolean isTempBlobName(String blobName) {
        return blobName.startsWith(TEMP_FILE_PREFIX);
    }

    protected BytesReference write(T obj) throws IOException {
        try (BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();){
            if (this.compress) {
                try (StreamOutput compressedStreamOutput = CompressorFactory.COMPRESSOR.streamOutput(bytesStreamOutput);){
                    this.write(obj, compressedStreamOutput);
                }
            } else {
                this.write(obj, bytesStreamOutput);
            }
            BytesReference bytesReference = bytesStreamOutput.bytes();
            return bytesReference;
        }
    }

    protected void write(T obj, StreamOutput streamOutput) throws IOException {
        try (XContentBuilder builder = XContentFactory.contentBuilder(this.xContentType, streamOutput);){
            builder.startObject();
            obj.toXContent(builder, SNAPSHOT_ONLY_FORMAT_PARAMS);
            builder.endObject();
        }
    }

    protected String tempBlobName(String name) {
        return TEMP_FILE_PREFIX + String.format(Locale.ROOT, this.blobNameFormat, name);
    }
}

