/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.fields.shared;

import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.forms.adf.definitions.annotations.SkipFormField;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;
import org.kie.workbench.common.forms.model.util.IDGenerator;

public abstract class AbstractFieldDefinition
implements FieldDefinition {
    public static final String ID_PREFFIX = "field_";
    @SkipFormField
    private String id;
    @SkipFormField
    protected String name;
    @FormField(labelKey="label")
    protected String label;
    @FormField(labelKey="required", afterElement="label")
    protected Boolean required = Boolean.FALSE;
    @FormField(labelKey="readOnly", afterElement="required")
    protected Boolean readOnly = Boolean.FALSE;
    @FormField(afterElement="readOnly", labelKey="validateOnChange")
    protected Boolean validateOnChange = Boolean.TRUE;
    @FormField(type=TextAreaFieldType.class, afterElement="validateOnChange", labelKey="helpMessage", helpMessageKey="helpMessage.helpMessage")
    private String helpMessage;
    @SkipFormField
    protected String binding;
    @SkipFormField
    protected String standaloneClassName;

    public AbstractFieldDefinition(String className) {
        this.id = ID_PREFFIX + IDGenerator.generateRandomId();
        this.standaloneClassName = className;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getHelpMessage() {
        return this.helpMessage;
    }

    public void setHelpMessage(String helpMessage) {
        this.helpMessage = helpMessage;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public String getStandaloneClassName() {
        return this.standaloneClassName;
    }

    public void setStandaloneClassName(String standaloneClassName) {
        this.standaloneClassName = standaloneClassName;
    }

    public TypeInfo getFieldTypeInfo() {
        return new TypeInfoImpl(this.standaloneClassName);
    }

    public Boolean getValidateOnChange() {
        return this.validateOnChange;
    }

    public void setValidateOnChange(Boolean validateOnChange) {
        this.validateOnChange = validateOnChange;
    }

    public void copyFrom(FieldDefinition other) {
        if (other == null) {
            return;
        }
        this.setLabel(other.getLabel());
        this.setStandaloneClassName(other.getStandaloneClassName());
        this.setBinding(other.getBinding());
        this.setRequired(other.getRequired());
        this.setReadOnly(other.getReadOnly());
        this.setValidateOnChange(other.getValidateOnChange());
        this.setHelpMessage(other.getHelpMessage());
        this.doCopyFrom(other);
    }

    protected abstract void doCopyFrom(FieldDefinition var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFieldDefinition that = (AbstractFieldDefinition)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.required != null ? !this.required.equals(that.required) : that.required != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.validateOnChange != null ? !this.validateOnChange.equals(that.validateOnChange) : that.validateOnChange != null) {
            return false;
        }
        if (this.helpMessage != null ? !this.helpMessage.equals(that.helpMessage) : that.helpMessage != null) {
            return false;
        }
        if (this.binding != null ? !this.binding.equals(that.binding) : that.binding != null) {
            return false;
        }
        return this.standaloneClassName != null ? this.standaloneClassName.equals(that.standaloneClassName) : that.standaloneClassName == null;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = ~(~result);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.validateOnChange != null ? this.validateOnChange.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.helpMessage != null ? this.helpMessage.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.binding != null ? this.binding.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.standaloneClassName != null ? this.standaloneClassName.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

