/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.enterprise.inject.Instance;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.events.AfterPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.AfterStageExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforePipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforeStageExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorStageExecutionEvent;
import org.guvnor.ala.pipeline.events.PipelineEvent;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.ExecutionIdGenerator;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineExecutorTaskManagerImplHelper {
    private static final Logger logger = LoggerFactory.getLogger(PipelineExecutorTaskManagerImplHelper.class);
    private Instance<ConfigExecutor> configExecutorInstance;
    private Instance<PipelineEventListener> pipelineEventListenerInstance;

    public PipelineExecutorTaskManagerImplHelper(Instance<ConfigExecutor> configExecutorInstance, Instance<PipelineEventListener> pipelineEventListenerInstance) {
        this.configExecutorInstance = configExecutorInstance;
        this.pipelineEventListenerInstance = pipelineEventListenerInstance;
    }

    public ExecutorService createExecutorService() {
        int threadPoolSize;
        String threadPoolSizeValue = System.getProperties().getProperty("org.guvnor.ala.pipeline.execution.threadPoolSize");
        if (threadPoolSizeValue == null) {
            threadPoolSize = 10;
            logger.debug("org.guvnor.ala.pipeline.execution.threadPoolSize property was not set, by default value will be used: 10");
        } else {
            try {
                threadPoolSize = Integer.parseInt(threadPoolSizeValue);
                if (threadPoolSize <= 0) {
                    threadPoolSize = 10;
                    logger.error("org.guvnor.ala.pipeline.execution.threadPoolSize property must be greater than 0, by default value will be used: 10");
                } else {
                    logger.debug("org.guvnor.ala.pipeline.execution.threadPoolSize property will be set to: " + threadPoolSize);
                }
            }
            catch (Exception e) {
                threadPoolSize = 10;
                logger.error("org.guvnor.ala.pipeline.execution.threadPoolSize property was set to a wrong value, by default value will be used: 10", (Throwable)e);
            }
        }
        return Executors.newFixedThreadPool(threadPoolSize);
    }

    public PipelineExecutor createPipelineExecutor() {
        ArrayList<ConfigExecutor> configs = new ArrayList<ConfigExecutor>();
        this.configExecutorInstance.iterator().forEachRemaining(configs::add);
        return this.newPipelineExecutor(configs);
    }

    protected PipelineExecutor newPipelineExecutor(Collection<ConfigExecutor> configs) {
        return new PipelineExecutor(configs);
    }

    public List<PipelineEventListener> createExternalListeners() {
        ArrayList<PipelineEventListener> eventListeners = new ArrayList<PipelineEventListener>();
        this.pipelineEventListenerInstance.iterator().forEachRemaining(eventListeners::add);
        return eventListeners;
    }

    public void notifyExternalListeners(List<PipelineEventListener> externalListeners, PipelineEvent event) {
        externalListeners.forEach(listener -> {
            try {
                if (event instanceof BeforePipelineExecutionEvent) {
                    listener.beforePipelineExecution((BeforePipelineExecutionEvent)event);
                } else if (event instanceof BeforeStageExecutionEvent) {
                    listener.beforeStageExecution((BeforeStageExecutionEvent)event);
                } else if (event instanceof AfterStageExecutionEvent) {
                    listener.afterStageExecution((AfterStageExecutionEvent)event);
                } else if (event instanceof AfterPipelineExecutionEvent) {
                    listener.afterPipelineExecution((AfterPipelineExecutionEvent)event);
                } else if (event instanceof OnErrorPipelineExecutionEvent) {
                    listener.onPipelineError((OnErrorPipelineExecutionEvent)event);
                } else if (event instanceof OnErrorStageExecutionEvent) {
                    listener.onStageError((OnErrorStageExecutionEvent)event);
                }
            }
            catch (Exception e) {
                logger.error("Pipeline event notification on listener: " + listener + " failed: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public PipelineExecutorTaskImpl createTask(PipelineExecutorTaskDef taskDef) {
        String executionId = this.generateTaskId();
        return this.createTask(taskDef, executionId);
    }

    public PipelineExecutorTaskImpl createTask(PipelineExecutorTaskDef taskDef, String executionId) {
        PipelineExecutorTaskImpl task = new PipelineExecutorTaskImpl(taskDef, executionId);
        return task;
    }

    public String generateTaskId() {
        return ExecutionIdGenerator.generateExecutionId();
    }

    public void setTaskInStoppedStatus(PipelineExecutorTaskImpl task) {
        task.setPipelineStatus(PipelineExecutorTask.Status.STOPPED);
        task.getTaskDef().getStages().stream().filter(stage -> PipelineExecutorTask.Status.RUNNING.equals((Object)task.getStageStatus((String)stage)) || PipelineExecutorTask.Status.SCHEDULED.equals((Object)task.getStageStatus((String)stage))).forEach(stage -> task.setStageStatus((String)stage, PipelineExecutorTask.Status.STOPPED));
        task.clearErrors();
        task.setOutput(null);
    }
}

