/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseReader;
import org.apache.sshd.server.auth.pubkey.KeySetPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;

public class AuthorizedKeyEntry
extends PublicKeyEntry {
    public static final char BOOLEAN_OPTION_NEGATION_INDICATOR = '!';
    private static final long serialVersionUID = -9007505285002809156L;
    private String comment;
    private Map<String, String> loginOptions = Collections.emptyMap();

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public Map<String, String> getLoginOptions() {
        return this.loginOptions;
    }

    public void setLoginOptions(Map<String, String> value) {
        this.loginOptions = value == null ? Collections.emptyMap() : value;
    }

    @Override
    public PublicKey appendPublicKey(Appendable sb, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        Map<String, String> options = this.getLoginOptions();
        if (!GenericUtils.isEmpty(options)) {
            int index = 0;
            for (Map.Entry<String, String> oe : options.entrySet()) {
                String key = oe.getKey();
                String value = oe.getValue();
                if (index > 0) {
                    sb.append(',');
                }
                sb.append(key);
                if (!Boolean.TRUE.toString().equals(value)) {
                    sb.append('=').append(value);
                }
                ++index;
            }
            if (index > 0) {
                sb.append(' ');
            }
        }
        PublicKey key = super.appendPublicKey(sb, fallbackResolver);
        String kc = this.getComment();
        if (!GenericUtils.isEmpty(kc)) {
            sb.append(' ').append(kc);
        }
        return key;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public String toString() {
        String entry = super.toString();
        String kc = this.getComment();
        Map<String, String> ko = this.getLoginOptions();
        return (GenericUtils.isEmpty(ko) ? "" : ko.toString() + " ") + entry + (GenericUtils.isEmpty(kc) ? "" : " " + kc);
    }

    public static PublickeyAuthenticator fromAuthorizedEntries(PublicKeyEntryResolver fallbackResolver, Collection<? extends AuthorizedKeyEntry> entries) throws IOException, GeneralSecurityException {
        List<PublicKey> keys = AuthorizedKeyEntry.resolveAuthorizedKeys(fallbackResolver, entries);
        if (GenericUtils.isEmpty(keys)) {
            return RejectAllPublickeyAuthenticator.INSTANCE;
        }
        return new KeySetPublickeyAuthenticator(keys);
    }

    public static List<PublicKey> resolveAuthorizedKeys(PublicKeyEntryResolver fallbackResolver, Collection<? extends AuthorizedKeyEntry> entries) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>(entries.size());
        for (AuthorizedKeyEntry authorizedKeyEntry : entries) {
            PublicKey k = authorizedKeyEntry.resolvePublicKey(fallbackResolver);
            if (k == null) continue;
            keys.add(k);
        }
        return keys;
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(in, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(in, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(Path path, OpenOption ... options) throws IOException {
        try (InputStream in = Files.newInputStream(path, options);){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(in, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(String filePath) throws IOException {
        try (FileInputStream in = new FileInputStream(filePath);){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(in, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(InputStream in, boolean okToClose) throws IOException {
        try (InputStreamReader rdr = new InputStreamReader(NoCloseInputStream.resolveInputStream(in, okToClose), StandardCharsets.UTF_8);){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(rdr, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(Reader rdr, boolean okToClose) throws IOException {
        try (BufferedReader buf = new BufferedReader(NoCloseReader.resolveReader(rdr, okToClose));){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(buf);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(BufferedReader rdr) throws IOException {
        ArrayList<AuthorizedKeyEntry> entries = null;
        String line = rdr.readLine();
        while (line != null) {
            block6: {
                AuthorizedKeyEntry entry;
                block5: {
                    try {
                        entry = AuthorizedKeyEntry.parseAuthorizedKeyEntry(line);
                        if (entry != null) break block5;
                        break block6;
                    }
                    catch (Error | RuntimeException e) {
                        throw new StreamCorruptedException("Failed (" + e.getClass().getSimpleName() + ") to parse key entry=" + line + ": " + e.getMessage());
                    }
                }
                if (entries == null) {
                    entries = new ArrayList<AuthorizedKeyEntry>();
                }
                entries.add(entry);
            }
            line = rdr.readLine();
        }
        if (entries == null) {
            return Collections.emptyList();
        }
        return entries;
    }

    public static AuthorizedKeyEntry parseAuthorizedKeyEntry(String value) throws IllegalArgumentException {
        AuthorizedKeyEntry entry;
        String keyType;
        PublicKeyEntryDecoder<?, ?> decoder;
        String line = GenericUtils.replaceWhitespaceAndTrim(value);
        if (GenericUtils.isEmpty(line) || line.charAt(0) == '#') {
            return null;
        }
        int startPos = line.indexOf(32);
        if (startPos <= 0) {
            throw new IllegalArgumentException("Bad format (no key data delimiter): " + line);
        }
        int endPos = line.indexOf(32, startPos + 1);
        if (endPos <= startPos) {
            endPos = line.length();
        }
        if ((decoder = KeyUtils.getPublicKeyEntryDecoder(keyType = line.substring(0, startPos))) == null) {
            AbstractMap.SimpleImmutableEntry<String, String> comps = AuthorizedKeyEntry.resolveEntryComponents(line);
            entry = AuthorizedKeyEntry.parseAuthorizedKeyEntry((String)comps.getValue());
            ValidateUtils.checkTrue(entry != null, "Bad format (no key data after login options): %s", (Object)line);
            entry.setLoginOptions(AuthorizedKeyEntry.parseLoginOptions((String)comps.getKey()));
        } else {
            String encData = endPos < line.length() - 1 ? line.substring(0, endPos).trim() : line;
            String comment = endPos < line.length() - 1 ? line.substring(endPos + 1).trim() : null;
            entry = AuthorizedKeyEntry.parsePublicKeyEntry(new AuthorizedKeyEntry(), encData);
            entry.setComment(comment);
        }
        return entry;
    }

    public static AbstractMap.SimpleImmutableEntry<String, String> resolveEntryComponents(String entryLine) {
        String line = GenericUtils.replaceWhitespaceAndTrim(entryLine);
        if (GenericUtils.isEmpty(line) || line.charAt(0) == '#') {
            return null;
        }
        int lastPos = 0;
        while (lastPos < line.length()) {
            int startPos = line.indexOf(32, lastPos);
            if (startPos < lastPos) {
                throw new IllegalArgumentException("Bad format (no key data delimiter): " + line);
            }
            int quotePos = line.indexOf(34, startPos + 1);
            if (quotePos > startPos) {
                lastPos = quotePos + 1;
                continue;
            }
            String loginOptions = line.substring(0, startPos).trim();
            String remainder = line.substring(startPos + 1).trim();
            return new AbstractMap.SimpleImmutableEntry<String, String>(loginOptions, remainder);
        }
        throw new IllegalArgumentException("Bad format (no key data contents): " + line);
    }

    public static NavigableMap<String, String> parseLoginOptions(String options) {
        int nextPos;
        String line = GenericUtils.replaceWhitespaceAndTrim(options);
        int len = GenericUtils.length(line);
        if (len <= 0) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, String> optsMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        int lastPos = 0;
        for (int curPos = 0; curPos < len && (nextPos = line.indexOf(44, curPos)) >= curPos; ++curPos) {
            int quotePos = line.indexOf(34, curPos);
            if (quotePos >= lastPos && quotePos < nextPos) {
                char ch;
                nextPos = line.indexOf(34, quotePos + 1);
                if (nextPos <= quotePos) {
                    throw new IllegalArgumentException("Bad format (imbalanced quoted command): " + line);
                }
                ++nextPos;
                while (nextPos < len && (ch = line.charAt(nextPos)) != ',') {
                    if (ch != ' ') {
                        throw new IllegalArgumentException("Bad format (incorrect list format): " + line);
                    }
                    ++nextPos;
                }
            }
            AuthorizedKeyEntry.addLoginOption(optsMap, line.substring(lastPos, nextPos));
            curPos = lastPos = nextPos + 1;
        }
        if (lastPos < len) {
            AuthorizedKeyEntry.addLoginOption(optsMap, line.substring(lastPos));
        }
        return optsMap;
    }

    public static AbstractMap.SimpleImmutableEntry<String, String> addLoginOption(Map<String, String> optsMap, String option) {
        AbstractMap.SimpleImmutableEntry<String, String> entry;
        String prev;
        String p = GenericUtils.trimToEmpty(option);
        if (GenericUtils.isEmpty(p)) {
            return null;
        }
        int pos = p.indexOf(61);
        String name = pos < 0 ? p : GenericUtils.trimToEmpty(p.substring(0, pos));
        CharSequence value = pos < 0 ? null : GenericUtils.trimToEmpty(p.substring(pos + 1));
        if ((value = GenericUtils.stripQuotes(value)) == null) {
            value = Boolean.toString(name.charAt(0) != '!');
        }
        if ((prev = optsMap.put((entry = new AbstractMap.SimpleImmutableEntry<String, String>(name, value.toString())).getKey(), entry.getValue())) != null) {
            if (pos < 0) {
                throw new IllegalStateException("Bad format (boolean option (" + name + ") re-specified): " + p);
            }
            optsMap.put(entry.getKey(), prev + "," + entry.getValue());
        }
        return entry;
    }
}

