/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedRequest;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.transport.netty4.Netty4Utils;

@ChannelHandler.Sharable
class Netty4HttpRequestHandler
extends SimpleChannelInboundHandler<Object> {
    private final Netty4HttpServerTransport serverTransport;
    private final boolean httpPipeliningEnabled;
    private final boolean detailedErrorsEnabled;
    private final ThreadContext threadContext;

    Netty4HttpRequestHandler(Netty4HttpServerTransport serverTransport, boolean detailedErrorsEnabled, ThreadContext threadContext) {
        this.serverTransport = serverTransport;
        this.httpPipeliningEnabled = serverTransport.pipelining;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.threadContext = threadContext;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Netty4HttpRequest httpRequest;
        FullHttpRequest request;
        HttpPipelinedRequest pipelinedRequest;
        if (this.httpPipeliningEnabled && msg instanceof HttpPipelinedRequest) {
            pipelinedRequest = (HttpPipelinedRequest)msg;
            request = (FullHttpRequest)pipelinedRequest.last();
        } else {
            pipelinedRequest = null;
            request = (FullHttpRequest)msg;
        }
        DefaultFullHttpRequest copy = new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), Unpooled.copiedBuffer((ByteBuf)request.content()), request.headers(), request.trailingHeaders());
        try {
            httpRequest = new Netty4HttpRequest(this.serverTransport.xContentRegistry, (FullHttpRequest)copy, ctx.channel());
        }
        catch (Exception ex) {
            if (pipelinedRequest != null) {
                pipelinedRequest.release();
            }
            throw ex;
        }
        Netty4HttpChannel channel = new Netty4HttpChannel(this.serverTransport, httpRequest, pipelinedRequest, this.detailedErrorsEnabled, this.threadContext);
        if (request.decoderResult().isSuccess()) {
            this.serverTransport.dispatchRequest(httpRequest, (RestChannel)channel);
        } else {
            assert (request.decoderResult().isFailure());
            this.serverTransport.dispatchBadRequest(httpRequest, (RestChannel)channel, request.decoderResult().cause());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Netty4Utils.maybeDie(cause);
        this.serverTransport.exceptionCaught(ctx, cause);
    }
}

