/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.profile.api.preferences;

import org.kie.workbench.common.profile.api.preferences.Profile;
import org.kie.workbench.common.profile.api.preferences.ProfileDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.preferences.shared.PropertyFormType;
import org.uberfire.preferences.shared.annotations.Property;
import org.uberfire.preferences.shared.annotations.WorkbenchPreference;
import org.uberfire.preferences.shared.bean.BasePreference;

@WorkbenchPreference(identifier="ProfilePreferences", bundleKey="ProfilePreferences.Label")
public class ProfilePreferences
implements BasePreference<ProfilePreferences> {
    private static Logger logger = LoggerFactory.getLogger((String)ProfilePreferences.class.getName());
    @Property(bundleKey="ProfilePreferences.Profiles", helpBundleKey="ProfilePreferences.Profiles.Help", formType=PropertyFormType.COMBO)
    private Profile profile;

    public ProfilePreferences() {
    }

    public ProfilePreferences(Profile profile) {
        this.profile = profile;
    }

    public ProfilePreferences defaultValue(ProfilePreferences defaultValue) {
        String profileStr = System.getProperty("org.kie.workbench.profile", Profile.FULL.name());
        Profile defaultProfile = Profile.FULL;
        try {
            if (profileStr.startsWith(ProfileDefinitions.FORCE_PREFIX)) {
                profileStr = profileStr.substring(ProfileDefinitions.FORCE_PREFIX.length());
            }
            defaultProfile = Profile.valueOf(profileStr);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Not able to load profile {}. Loading FULL profile.", (Object)profileStr);
        }
        defaultValue.setProfile(defaultProfile);
        return defaultValue;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }
}

