/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.service;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfig;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.core.LRUBuilderCache;
import org.kie.workbench.common.services.backend.builder.service.BuildServiceHelper;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class BuildServiceImpl
implements BuildService {
    private BuildServiceHelper buildServiceHelper;
    private KieModuleService moduleService;
    private LRUBuilderCache cache;

    public BuildServiceImpl() {
    }

    @Inject
    public BuildServiceImpl(KieModuleService moduleService, BuildServiceHelper buildServiceHelper, LRUBuilderCache cache) {
        this.moduleService = moduleService;
        this.buildServiceHelper = buildServiceHelper;
        this.cache = cache;
    }

    public BuildResults build(Module module) {
        return this.buildServiceHelper.localBuild(module);
    }

    public void build(Module module, Consumer<Builder> consumer) {
        this.buildServiceHelper.localBuild(module, localBinaryConfig -> consumer.accept(localBinaryConfig.getBuilder()));
    }

    public BuildResults buildAndDeploy(Module module) {
        return this.buildAndDeploy(module, DeploymentMode.VALIDATED);
    }

    public BuildResults buildAndDeploy(Module module, DeploymentMode mode) {
        return this.buildAndDeploy(module, false, mode);
    }

    public BuildResults buildAndDeploy(Module module, boolean suppressHandlers) {
        return this.buildAndDeploy(module, suppressHandlers, DeploymentMode.VALIDATED);
    }

    public BuildResults buildAndDeploy(Module module, boolean suppressHandlers, DeploymentMode mode) {
        return this.buildServiceHelper.localBuildAndDeploy(module, mode, suppressHandlers);
    }

    public boolean isBuilt(Module module) {
        Builder builder = this.cache.assertBuilder(module);
        return builder.isBuilt();
    }

    public IncrementalBuildResults addPackageResource(Path resource) {
        return this.buildIncrementally(resource, LocalBuildConfig.BuildType.INCREMENTAL_ADD_RESOURCE);
    }

    public IncrementalBuildResults deletePackageResource(Path resource) {
        return this.buildIncrementally(resource, LocalBuildConfig.BuildType.INCREMENTAL_DELETE_RESOURCE);
    }

    public IncrementalBuildResults updatePackageResource(Path resource) {
        return this.buildIncrementally(resource, LocalBuildConfig.BuildType.INCREMENTAL_UPDATE_RESOURCE);
    }

    private IncrementalBuildResults buildIncrementally(Path resource, LocalBuildConfig.BuildType buildType) {
        Module module = this.moduleService.resolveModule(resource);
        if (module == null) {
            return new IncrementalBuildResults();
        }
        return this.buildServiceHelper.localBuild(module, buildType, resource);
    }

    public IncrementalBuildResults applyBatchResourceChanges(Module module, Map<Path, Collection<ResourceChange>> changes) {
        if (module == null) {
            return new IncrementalBuildResults();
        }
        return this.buildServiceHelper.localBuild(module, changes);
    }
}

