/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;

public class MapClassLoader
extends ClassLoader {
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return MapClassLoader.class.getProtectionDomain();
        }
    });
    private Map<String, byte[]> map;

    public MapClassLoader(Map<String, byte[]> map, ClassLoader parent) {
        super(parent);
        this.map = map;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.fastFindClass(name);
        if (cls == null) {
            cls = super.loadClass(name, resolve);
        }
        if (cls == null) {
            throw new ClassNotFoundException("Unable to load class: " + name);
        }
        return cls;
    }

    public Class<?> fastFindClass(String name) {
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null) {
            byte[] clazzBytes = this.map.get(MapClassLoader.convertClassToResourcePath(name));
            if (clazzBytes != null) {
                String pkgName;
                int lastDotPos = name.lastIndexOf(46);
                String string = pkgName = lastDotPos > 0 ? name.substring(0, lastDotPos) : "";
                if (this.getPackage(pkgName) == null) {
                    this.definePackage(pkgName, "", "", "", "", "", "", null);
                }
                cls = this.defineClass(name, clazzBytes, 0, clazzBytes.length, PROTECTION_DOMAIN);
            }
            if (cls != null) {
                this.resolveClass(cls);
            }
        }
        return cls;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] clsBytes = this.map.get(name);
        if (clsBytes != null) {
            return new ByteArrayInputStream(clsBytes);
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }
}

