/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.shared.preferences.config;

import java.util.List;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.services.shared.preferences.config.WorkbenchPreferenceScopes;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeResolver;
import org.uberfire.preferences.shared.impl.exception.InvalidPreferenceScopeException;

@Portable
public class WorkbenchPreferenceScopeResolver
implements PreferenceScopeResolver {
    private final List<PreferenceScope> order;

    public WorkbenchPreferenceScopeResolver(@MapsTo(value="order") List<PreferenceScope> order) {
        this.order = order;
    }

    public PreferenceScope resolve(String ... scopeTypes) {
        if (scopeTypes != null && scopeTypes.length == 1) {
            if (WorkbenchPreferenceScopes.getUserScopedScopes().contains(scopeTypes[0])) {
                return this.getScopeFromOrder("user", scopeTypes[0]);
            }
            return this.getScopeFromOrder(scopeTypes);
        }
        throw new InvalidPreferenceScopeException("The passed scope types are invalid.");
    }

    private PreferenceScope getScopeFromOrder(String ... scopeTypes) {
        for (PreferenceScope scope : this.order) {
            boolean match = true;
            PreferenceScope currentScope = scope;
            for (int i = 0; i < scopeTypes.length; ++i) {
                if (currentScope == null || !currentScope.type().equals(scopeTypes[i])) {
                    match = false;
                    break;
                }
                currentScope = currentScope.childScope();
            }
            if (!match || currentScope != null) continue;
            return scope;
        }
        throw new InvalidPreferenceScopeException("The passed scope types are invalid.");
    }
}

