/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.loading;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.function.Consumer;
import org.uberfire.client.mvp.AbstractWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.jsbridge.JsWorkbenchLazyPerspective;
import org.uberfire.client.workbench.panels.impl.ImmutableWorkbenchPanelPresenter;
import org.uberfire.jsbridge.client.loading.AppFormerComponentsRegistry;
import org.uberfire.jsbridge.client.perspective.JsWorkbenchPerspectiveActivity;
import org.uberfire.jsbridge.client.perspective.JsWorkbenchTemplatedPerspectiveActivity;
import org.uberfire.jsbridge.client.perspective.jsnative.JsNativePerspective;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.ForcedPlaceRequest;
import org.uberfire.security.ResourceType;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.toolbar.ToolBar;

public class JsWorkbenchLazyPerspectiveActivity
extends AbstractWorkbenchPerspectiveActivity
implements JsWorkbenchLazyPerspective {
    private final ActivityManager activityManager;
    private final String backedPerspectiveId;
    private final boolean configuredIsDefault;
    PerspectiveActivity backedPerspective;
    private boolean loaded;
    private final Consumer<String> lazyLoadingParentScript;

    public JsWorkbenchLazyPerspectiveActivity(AppFormerComponentsRegistry.Entry registryEntry, PlaceManager placeManager, ActivityManager activityManager, Consumer<String> lazyLoadingParentScript) {
        super(placeManager);
        this.activityManager = activityManager;
        this.backedPerspectiveId = registryEntry.getComponentId();
        this.lazyLoadingParentScript = lazyLoadingParentScript;
        this.configuredIsDefault = new AppFormerComponentsRegistry.Entry.PerspectiveParams(registryEntry.getParams()).isDefault().orElse(super.isDefault());
        this.loaded = false;
    }

    public void updateRealContent(JavaScriptObject backedPerspectiveJsObject) {
        this.loaded = true;
        this.backedPerspective = this.getBackedPerspective(backedPerspectiveJsObject);
        if (this.activityManager.isStarted((Activity)this)) {
            this.getBackedPerspective().onStartup(this.place);
        }
        if (this.open) {
            this.getBackedPerspective().onOpen();
            this.placeManager.goTo((PlaceRequest)new ForcedPlaceRequest(this.backedPerspectiveId));
        }
    }

    PerspectiveActivity getBackedPerspective(JavaScriptObject backedPerspectiveJsObject) {
        JsNativePerspective jsPerspective = new JsNativePerspective(backedPerspectiveJsObject);
        if (this.isPerspectiveTemplated(jsPerspective)) {
            return new JsWorkbenchTemplatedPerspectiveActivity(this.getIdentifier(), this.isDefault(), jsPerspective, this.placeManager);
        }
        return new JsWorkbenchPerspectiveActivity(jsPerspective, this.placeManager, this.isDefault());
    }

    public boolean isPerspectiveTemplated(JsNativePerspective jsPerspective) {
        return jsPerspective.isTemplated();
    }

    public PerspectiveActivity get() {
        if (this.isPerspectiveLoaded()) {
            return this.getBackedPerspective();
        }
        return this;
    }

    public void onStartup(PlaceRequest place) {
        this.place = place;
        if (this.isPerspectiveLoaded()) {
            this.getBackedPerspective().onStartup(place);
            return;
        }
        super.onStartup(place);
    }

    public void onOpen() {
        if (this.isPerspectiveLoaded()) {
            this.getBackedPerspective().onOpen();
        } else {
            super.onOpen();
            this.onLoaded();
        }
        this.placeManager.executeOnOpenCallbacks(this.place);
    }

    public void onClose() {
        if (this.isPerspectiveLoaded()) {
            this.getBackedPerspective().onClose();
        } else {
            super.onClose();
        }
        this.placeManager.executeOnCloseCallbacks(this.place);
    }

    public void onShutdown() {
        if (this.isPerspectiveLoaded()) {
            this.getBackedPerspective().onShutdown();
            return;
        }
        super.onShutdown();
    }

    void onLoaded() {
        this.lazyLoadingParentScript.accept(this.backedPerspectiveId);
    }

    PerspectiveActivity getBackedPerspective() {
        return this.backedPerspective;
    }

    public ResourceType getResourceType() {
        return ActivityResourceType.PERSPECTIVE;
    }

    public String getIdentifier() {
        return this.backedPerspectiveId;
    }

    public boolean isDefault() {
        return this.configuredIsDefault;
    }

    public boolean isTransient() {
        if (this.isPerspectiveLoaded()) {
            return this.getBackedPerspective().isTransient();
        }
        return true;
    }

    public void getMenus(Consumer<Menus> consumer) {
        if (this.isPerspectiveLoaded()) {
            this.getBackedPerspective().getMenus(consumer);
        } else {
            super.getMenus(consumer);
        }
    }

    public ToolBar getToolBar() {
        if (this.isPerspectiveLoaded()) {
            return this.getBackedPerspective().getToolBar();
        }
        return super.getToolBar();
    }

    public PerspectiveDefinition getDefaultPerspectiveLayout() {
        if (this.isPerspectiveLoaded()) {
            return this.getBackedPerspective().getDefaultPerspectiveLayout();
        }
        return this.buildEmptyDefinition();
    }

    boolean isPerspectiveLoaded() {
        return this.loaded;
    }

    private PerspectiveDefinition buildEmptyDefinition() {
        PerspectiveDefinitionImpl def = new PerspectiveDefinitionImpl(ImmutableWorkbenchPanelPresenter.class.getName());
        def.setName(this.getIdentifier());
        def.getRoot().addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("LazyLoadingScreen")));
        return def;
    }
}

