/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.dropdown;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.DropDown;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.Toggle;

public class ListDropdown
extends DropDown {
    protected Button button = (Button)GWT.create(Button.class);
    protected DropDownMenu dropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
    protected boolean hideOnSingleElement = true;

    public ListDropdown() {
        super.add((Widget)this.button);
        super.add((Widget)this.dropDownMenu);
        this.button.setType(ButtonType.LINK);
        this.addStyleName("uf-list-dropdown");
    }

    public void add(Widget child) {
        if (child instanceof ListItem) {
            this.dropDownMenu.add(child);
            this.addCaretToText();
        }
    }

    public void setText(Widget text) {
        this.removeChildWidgets((ComplexPanel)this.button);
        this.button.add(text);
        this.addCaretToText();
    }

    public boolean remove(Widget w) {
        boolean remove = this.dropDownMenu.remove(w);
        this.addCaretToText();
        return remove;
    }

    public void setHideOnSingleElement(boolean hide) {
        this.hideOnSingleElement = hide;
    }

    public void clear() {
        this.removeChildWidgets((ComplexPanel)this.button);
        this.removeChildWidgets((ComplexPanel)this.dropDownMenu);
    }

    private void removeChildWidgets(ComplexPanel panel) {
        Iterator iterator = panel.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    protected void addCaretToText() {
        if (this.hideOnSingleElement && this.dropDownMenu.getWidgetCount() == 1) {
            this.button.setToggleCaret(false);
            this.button.setDataToggle(null);
            this.removeStyleName("open");
            this.toggleStyles(true);
        } else if (this.dropDownMenu.getWidgetCount() > 1 || !this.hideOnSingleElement && this.dropDownMenu.getWidgetCount() == 1) {
            this.button.setToggleCaret(true);
            this.button.setDataToggle(Toggle.DROPDOWN);
            this.button.setDataTargetWidget((Widget)this);
            this.toggleStyles(false);
        }
    }

    private void toggleStyles(boolean single) {
        this.removeStyleName("uf-list-dropdown-single");
        this.removeStyleName("uf-list-dropdown-multi");
        this.addStyleName(single ? "uf-list-dropdown-single" : "uf-list-dropdown-multi");
    }
}

