/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, name = "Number", namespace = JsPackage.GLOBAL)
class JsNumber__Constants {
  static double EPSILON;
  static double MAX_SAFE_INTEGER;
  static double MAX_VALUE;
  static double MIN_SAFE_INTEGER;
  static double MIN_VALUE;
  static double NEGATIVE_INFINITY;
  static double NaN;
  static double POSITIVE_INFINITY;
}
