/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.PredicateDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.EvalConditionFactory;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.mvel.java.JavaRuleBuilderHelper;

public abstract class AbstractASMEvalBuilder
implements RuleConditionBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        EvalDescr evalDescr = (EvalDescr)descr;
        Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
        AnalysisResult analysis = context.getDialect().analyzeExpression((PackageBuildContext)context, (BaseDescr)evalDescr, evalDescr.getContent(), new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), (PackageBuildContext)context));
        ArrayList<Declaration> requiredDeclarations = new ArrayList<Declaration>();
        for (String usedIdentifier : analysis.getIdentifiers()) {
            Declaration usedDec = (Declaration)decls.get(usedIdentifier);
            if (usedDec == null) continue;
            requiredDeclarations.add(usedDec);
        }
        Declaration[] declarations = requiredDeclarations.toArray(new Declaration[requiredDeclarations.size()]);
        return this.buildEval(context, evalDescr, analysis, declarations);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        if (prefixPattern == null) {
            return this.build(context, descr);
        }
        EvalDescr evalDescr = (EvalDescr)descr;
        PredicateDescr predicateDescr = new PredicateDescr(context.getRuleDescr().getResource(), evalDescr.getContent());
        AnalysisResult analysis = PatternBuilder.buildAnalysis((RuleBuildContext)context, (Pattern)prefixPattern, (PredicateDescr)predicateDescr, null);
        Declaration[] declarations = this.getUsedDeclarations(context, prefixPattern, analysis);
        return this.buildEval(context, evalDescr, analysis, declarations);
    }

    private RuleConditionElement buildEval(RuleBuildContext context, EvalDescr evalDescr, AnalysisResult analysis, Declaration[] declarations) {
        String className = "eval" + context.getNextId();
        evalDescr.setClassMethodName(className);
        Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
        EvalCondition eval = EvalConditionFactory.Factory.get().createEvalCondition(declarations);
        Map<String, Object> vars = JavaRuleBuilderHelper.createVariableContext(className, (String)evalDescr.getContent(), context, declarations, null, analysis.getBoundIdentifiers().getGlobals());
        JavaRuleBuilderHelper.generateMethodTemplate("evalMethod", context, vars);
        byte[] bytecode = this.createEvalBytecode(context, vars);
        JavaRuleBuilderHelper.registerInvokerBytecode(context, vars, bytecode, eval);
        return eval;
    }

    private Declaration[] getUsedDeclarations(RuleBuildContext context, Pattern pattern, AnalysisResult analysis) {
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            declarations.add(context.getDeclarationResolver().getDeclaration(id));
        }
        PatternBuilder.createImplicitBindings((RuleBuildContext)context, (Pattern)pattern, (Set)analysis.getNotBoundedIdentifiers(), (BoundIdentifiers)analysis.getBoundIdentifiers(), declarations);
        return declarations.toArray(new Declaration[declarations.size()]);
    }

    protected abstract byte[] createEvalBytecode(RuleBuildContext var1, Map var2);
}

