/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ecj;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.drools.compiler.shade.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.ClassFile;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.Compiler;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.IoUtils;
import org.drools.ecj.EclipseCompilationProblem;
import org.drools.ecj.EclipseJavaCompilerSettings;
import org.kie.memorycompiler.AbstractJavaCompiler;
import org.kie.memorycompiler.CompilationProblem;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;

public final class EclipseJavaCompiler
extends AbstractJavaCompiler {
    private String sourceFolder = "";
    private final EclipseJavaCompilerSettings defaultSettings;

    public EclipseJavaCompiler() {
        this(new EclipseJavaCompilerSettings(), "");
    }

    public EclipseJavaCompiler(Map pSettings) {
        this.defaultSettings = new EclipseJavaCompilerSettings(pSettings);
    }

    public EclipseJavaCompiler(EclipseJavaCompilerSettings pSettings, String sourceFolder) {
        this.defaultSettings = pSettings;
        this.sourceFolder = sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getPathName(String fullPath) {
        if (this.sourceFolder.length() == 0) {
            return fullPath;
        }
        if (fullPath.charAt(0) == '/') {
            return fullPath.substring(this.sourceFolder.length() + 1);
        }
        return fullPath.substring(this.sourceFolder.length());
    }

    public CompilationResult compile(String[] pSourceFiles, final ResourceReader pReader, final ResourceStore pStore, final ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
        ArrayList<1> problems = new ArrayList<1>();
        ICompilationUnit[] compilationUnits = new ICompilationUnit[pSourceFiles.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            final String sourceFile = pSourceFiles[i];
            if (pReader.isAvailable(sourceFile)) {
                compilationUnits[i] = new CompilationUnit(pReader, sourceFile);
                continue;
            }
            CompilationProblem problem = new CompilationProblem(){

                public int getEndColumn() {
                    return 0;
                }

                public int getEndLine() {
                    return 0;
                }

                public String getFileName() {
                    return sourceFile;
                }

                public String getMessage() {
                    return "Source " + sourceFile + " could not be found";
                }

                public int getStartColumn() {
                    return 0;
                }

                public int getStartLine() {
                    return 0;
                }

                public boolean isError() {
                    return true;
                }

                public String toString() {
                    return this.getMessage();
                }
            };
            problems.add(problem);
        }
        if (problems.size() > 0) {
            CompilationProblem[] result = new CompilationProblem[problems.size()];
            problems.toArray(result);
            return new CompilationResult(result);
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        INameEnvironment nameEnvironment = new INameEnvironment(){

            @Override
            public NameEnvironmentAnswer findType(char[][] pCompoundTypeName) {
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < pCompoundTypeName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(pCompoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            @Override
            public NameEnvironmentAnswer findType(char[] pTypeName, char[][] pPackageName) {
                StringBuilder result = new StringBuilder();
                for (char[] chars : pPackageName) {
                    result.append(chars);
                    result.append('.');
                }
                result.append(pTypeName);
                return this.findType(result.toString());
            }

            /*
             * Exception decompiling
             */
            private NameEnvironmentAnswer findType(String pClazzName) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private NameEnvironmentAnswer createNameEnvironmentAnswer(String pClazzName, byte[] clazzBytes) throws ClassFormatException {
                char[] fileName = pClazzName.toCharArray();
                ClassFileReader classFileReader = new ClassFileReader(clazzBytes, fileName, true);
                return new NameEnvironmentAnswer(classFileReader, null);
            }

            private boolean isSourceAvailable(String pClazzName, ResourceReader pReader2) {
                String javaSource = pClazzName.replace('.', '/') + ".java";
                String classSource = pClazzName.replace('.', '/') + ".class";
                return pReader2.isAvailable(EclipseJavaCompiler.this.sourceFolder + javaSource) || pReader2.isAvailable(EclipseJavaCompiler.this.sourceFolder + classSource);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean isPackage(String pClazzName) {
                try (InputStream is = pClassLoader.getResourceAsStream(ClassUtils.convertClassToResourcePath((String)pClazzName));){
                    if (is != null && (ClassUtils.isWindows() || ClassUtils.isOSX())) {
                        try {
                            Class<?> cls = pClassLoader.loadClass(pClazzName);
                            if (cls != null) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        catch (ClassNotFoundException | NoClassDefFoundError e) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    boolean bl = is == null && !this.isSourceAvailable(pClazzName, pReader);
                    return bl;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot open or close resource stream!", e);
                }
            }

            @Override
            public boolean isPackage(char[][] parentPackageName, char[] pPackageName) {
                StringBuilder result = new StringBuilder();
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        if (i != 0) {
                            result.append('.');
                        }
                        result.append(parentPackageName[i]);
                    }
                }
                if (parentPackageName != null && parentPackageName.length > 0) {
                    result.append('.');
                }
                result.append(pPackageName);
                return this.isPackage(result.toString());
            }

            @Override
            public void cleanup() {
            }
        };
        ICompilerRequestor compilerRequestor = pResult -> {
            if (pResult.hasProblems()) {
                CategorizedProblem[] iproblems = pResult.getProblems();
                for (CategorizedProblem iproblem : iproblems) {
                    EclipseCompilationProblem problem = new EclipseCompilationProblem(iproblem);
                    problems.add((Object)problem);
                }
            }
            if (!pResult.hasErrors()) {
                ClassFile[] clazzFiles = pResult.getClassFiles();
                for (ClassFile clazzFile : clazzFiles) {
                    char[][] compoundName = clazzFile.getCompoundName();
                    StringBuilder clazzName = new StringBuilder();
                    for (int j = 0; j < compoundName.length; ++j) {
                        if (j != 0) {
                            clazzName.append('.');
                        }
                        clazzName.append(compoundName[j]);
                    }
                    pStore.write(clazzName.toString().replace('.', '/') + ".class", clazzFile.getBytes());
                }
            }
        };
        Map settingsMap = new EclipseJavaCompilerSettings(pSettings).toNativeSettings();
        CompilerOptions compilerOptions = new CompilerOptions(settingsMap);
        compilerOptions.parseLiteralExpressionsAsConstants = false;
        Compiler compiler = new Compiler(nameEnvironment, policy, compilerOptions, compilerRequestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        problems.toArray(result);
        return new CompilationResult(result);
    }

    private void dumpUnits(ICompilationUnit[] compilationUnits, ResourceReader reader) {
        for (ICompilationUnit unit : compilationUnits) {
            String name = ((CompilationUnit)unit).fileName;
            String source = new String(reader.getBytes(name));
            try {
                IoUtils.write((File)new File(name.replace('/', '.')), (byte[])reader.getBytes(name));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public JavaCompilerSettings createDefaultSettings() {
        return this.defaultSettings;
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String fsFileName;
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;
        private final ResourceReader reader;

        CompilationUnit(ResourceReader pReader, String pSourceFile) {
            this.reader = pReader;
            this.fsFileName = pSourceFile;
            this.clazzName = ClassUtils.convertResourceToClassName((String)this.decode(EclipseJavaCompiler.this.getPathName(pSourceFile)));
            this.fileName = this.decode(pSourceFile);
            int dot = this.clazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? this.clazzName.substring(dot + 1).toCharArray() : this.clazzName.toCharArray();
            StringTokenizer izer = new StringTokenizer(this.clazzName, ".");
            this.packageName = new char[izer.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = izer.nextToken().toCharArray();
            }
        }

        private String decode(String path) {
            try {
                return URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return path;
            }
        }

        @Override
        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        @Override
        public char[] getContents() {
            byte[] content = this.reader.getBytes(this.fsFileName);
            if (content == null) {
                return null;
            }
            return new String(content, IoUtils.UTF8_CHARSET).toCharArray();
        }

        @Override
        public char[] getMainTypeName() {
            return this.typeName;
        }

        @Override
        public char[][] getPackageName() {
            return this.packageName;
        }

        @Override
        public boolean ignoreOptionalProblems() {
            return true;
        }
    }
}

