/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.impl.ClassDefinitionFactory;
import org.drools.compiler.builder.impl.ClassHierarchyManager;
import org.drools.compiler.builder.impl.DeclaredClassBuilder;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationCache;
import org.drools.compiler.builder.impl.TypeDeclarationConfigurator;
import org.drools.compiler.builder.impl.TypeDeclarationFactory;
import org.drools.compiler.builder.impl.TypeDeclarationNameResolver;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.QualifiedName;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.ClassBuilder;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.rule.TypeDeclaration;
import org.kie.api.io.Resource;
import org.kie.internal.builder.ResourceChange;

public class TypeDeclarationBuilder {
    protected final KnowledgeBuilderImpl kbuilder;
    protected final Set<String> generatedTypes = new HashSet<String>();
    protected TypeDeclarationCache classDeclarationExtractor;
    protected TypeDeclarationNameResolver typeDeclarationNameResolver;
    protected TypeDeclarationFactory typeDeclarationFactory;
    protected ClassDefinitionFactory classDefinitionFactory;
    protected TypeDeclarationConfigurator typeDeclarationConfigurator;
    protected DeclaredClassBuilder declaredClassBuilder;

    public TypeDeclarationBuilder(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
        this.classDeclarationExtractor = new TypeDeclarationCache(kbuilder);
        this.typeDeclarationNameResolver = new TypeDeclarationNameResolver(kbuilder);
        this.typeDeclarationFactory = new TypeDeclarationFactory(kbuilder);
        this.classDefinitionFactory = new ClassDefinitionFactory(kbuilder);
        this.typeDeclarationConfigurator = new TypeDeclarationConfigurator(kbuilder);
        this.declaredClassBuilder = new DeclaredClassBuilder(kbuilder);
    }

    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        return this.classDeclarationExtractor.getAndRegisterTypeDeclaration(cls, packageName);
    }

    public TypeDeclaration getExistingTypeDeclaration(String className) {
        return this.classDeclarationExtractor.getCachedTypeDeclaration(className);
    }

    public TypeDeclaration getTypeDeclaration(Class<?> cls) {
        return this.classDeclarationExtractor.getTypeDeclaration(cls);
    }

    public Collection<String> removeTypesGeneratedFromResource(Resource resource) {
        Collection<String> removedTypes = this.classDeclarationExtractor.removeTypesGeneratedFromResource(resource);
        this.generatedTypes.removeAll(removedTypes);
        return removedTypes;
    }

    void registerGeneratedType(AbstractClassTypeDeclarationDescr typeDescr) {
        String fullName = typeDescr.getType().getFullName();
        this.generatedTypes.add(fullName);
    }

    public void processTypeDeclarations(Collection<? extends PackageDescr> packageDescrs, Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        packageDescrs.forEach(this.kbuilder::getOrCreatePackageRegistry);
        packageDescrs.forEach(this::setResourcesInDescriptors);
        this.typeDeclarationNameResolver.resolveTypes(packageDescrs, unresolvedTypes);
        packageDescrs.forEach(this::normalizeForeignPackages);
        this.processUnresolvedTypes(null, null, unsortedDescrs, unresolvedTypes, unprocesseableDescrs);
    }

    public void processTypeDeclarations(PackageDescr packageDescr, PackageRegistry pkgRegistry, Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        this.setResourcesInDescriptors(packageDescr);
        this.typeDeclarationNameResolver.resolveTypes(packageDescr, unresolvedTypes, pkgRegistry.getTypeResolver());
        this.normalizeForeignPackages(packageDescr);
        this.processUnresolvedTypes(packageDescr, pkgRegistry, unsortedDescrs, unresolvedTypes, unprocesseableDescrs);
    }

    private void processUnresolvedTypes(PackageDescr packageDescr, PackageRegistry pkgRegistry, Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        PackageRegistry pkgReg;
        unsortedDescrs = this.compactDefinitionsAndDeclarations(unsortedDescrs, unprocesseableDescrs);
        ClassHierarchyManager classHierarchyManager = new ClassHierarchyManager(unsortedDescrs, this.kbuilder);
        for (AbstractClassTypeDeclarationDescr typeDescr : classHierarchyManager.getSortedDescriptors()) {
            pkgReg = this.getPackageRegistry(pkgRegistry, packageDescr, typeDescr);
            this.createBean(typeDescr, pkgReg, classHierarchyManager, unresolvedTypes, unprocesseableDescrs);
        }
        for (AbstractClassTypeDeclarationDescr typeDescr : classHierarchyManager.getSortedDescriptors()) {
            if (unprocesseableDescrs.containsKey(typeDescr.getType().getFullName())) continue;
            pkgReg = this.getPackageRegistry(pkgRegistry, packageDescr, typeDescr);
            InternalKnowledgePackage pkg = pkgReg.getPackage();
            TypeDeclaration type = pkg.getTypeDeclaration(typeDescr.getType().getName());
            this.typeDeclarationConfigurator.wireFieldAccessors(pkgReg, typeDescr, type);
            if (this.kbuilder.getKnowledgeBase() == null) continue;
            this.kbuilder.getKnowledgeBase().registerTypeDeclaration(type, pkg);
        }
    }

    private PackageRegistry getPackageRegistry(PackageRegistry pkgRegistry, PackageDescr packageDescr, AbstractClassTypeDeclarationDescr typeDescr) {
        return pkgRegistry != null && typeDescr.getNamespace().equals(packageDescr.getName()) ? pkgRegistry : this.kbuilder.getPackageRegistry(typeDescr.getNamespace());
    }

    private Collection<AbstractClassTypeDeclarationDescr> compactDefinitionsAndDeclarations(Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        HashMap<String, AbstractClassTypeDeclarationDescr> compactedUnsorted = new HashMap<String, AbstractClassTypeDeclarationDescr>(unsortedDescrs.size());
        for (AbstractClassTypeDeclarationDescr descr : unsortedDescrs) {
            if (compactedUnsorted.containsKey(descr.getType().getFullName())) {
                AbstractClassTypeDeclarationDescr prev = (AbstractClassTypeDeclarationDescr)compactedUnsorted.get(descr.getType().getFullName());
                boolean res = this.mergeTypeDescriptors(prev, descr);
                if (res) continue;
                unprocesseableDescrs.put(prev.getType().getFullName(), prev);
                this.kbuilder.addBuilderResult(new TypeDeclarationError(prev, "Found duplicate declaration for type " + prev.getType().getFullName() + ", unable to reconcile "));
                continue;
            }
            compactedUnsorted.put(descr.getType().getFullName(), descr);
        }
        return compactedUnsorted.values();
    }

    private boolean mergeTypeDescriptors(AbstractClassTypeDeclarationDescr prev, AbstractClassTypeDeclarationDescr descr) {
        boolean isDef1 = this.isDefinition(prev);
        boolean isDef2 = this.isDefinition(descr);
        if (isDef1 && isDef2) {
            return false;
        }
        if (!prev.getSuperTypes().isEmpty() && !descr.getSuperTypes().isEmpty() && prev.getSuperTypes().size() != descr.getSuperTypes().size()) {
            return false;
        }
        if (prev.getSuperTypes().isEmpty()) {
            for (QualifiedName qn : descr.getSuperTypes()) {
                ((TypeDeclarationDescr)prev).addSuperType(qn);
            }
        }
        if (prev.getFields().isEmpty()) {
            for (String fieldName : descr.getFields().keySet()) {
                prev.addField(descr.getFields().get(fieldName));
            }
        }
        for (AnnotationDescr ad : descr.getAnnotations()) {
            prev.addQualifiedAnnotation(ad);
        }
        for (AnnotationDescr ad : prev.getAnnotations()) {
            if (descr.getAnnotations().contains(ad)) continue;
            descr.addQualifiedAnnotation(ad);
        }
        return true;
    }

    private boolean isDefinition(AbstractClassTypeDeclarationDescr prev) {
        return !prev.getFields().isEmpty();
    }

    private void setResourcesInDescriptors(PackageDescr packageDescr) {
        for (AbstractClassTypeDeclarationDescr typeDescr : packageDescr.getClassAndEnumDeclarationDescrs()) {
            if (typeDescr.getResource() != null) continue;
            typeDescr.setResource(this.kbuilder.getCurrentResource());
        }
    }

    protected void createBean(AbstractClassTypeDeclarationDescr typeDescr, PackageRegistry pkgRegistry, ClassHierarchyManager hierarchyManager, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        if (typeDescr instanceof TypeDeclarationDescr) {
            hierarchyManager.inheritFields(pkgRegistry, typeDescr, hierarchyManager.getSortedDescriptors(), unresolvedTypes, unprocesseableDescrs);
        }
        TypeDeclaration type = this.typeDeclarationFactory.processTypeDeclaration(pkgRegistry, typeDescr);
        boolean success = !this.kbuilder.hasErrors();
        try {
            ClassDefinition def = null;
            if (success) {
                def = this.classDefinitionFactory.generateDeclaredBean(typeDescr, type, pkgRegistry, unresolvedTypes, unprocesseableDescrs);
                if (!type.isNovel()) {
                    this.typeDeclarationFactory.checkRedeclaration(typeDescr, type, pkgRegistry);
                }
            }
            boolean bl = success = def != null && !this.kbuilder.hasErrors();
            if (success) {
                this.postGenerateDeclaredBean(typeDescr, type, def, pkgRegistry);
            }
            boolean bl2 = success = !this.kbuilder.hasErrors();
            if (success) {
                ClassBuilder classBuilder = this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getClassBuilder(type);
                this.declaredClassBuilder.generateBeanFromDefinition(typeDescr, type, pkgRegistry, def, classBuilder);
            }
            boolean bl3 = success = !this.kbuilder.hasErrors();
            if (success) {
                Class clazz = pkgRegistry.getTypeResolver().resolveType(typeDescr.getType().getFullName());
                type.setTypeClass(clazz);
                type.setValid(true);
            } else {
                unprocesseableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
                type.setValid(false);
            }
            this.typeDeclarationConfigurator.finalizeConfigurator(type, typeDescr, pkgRegistry, this.kbuilder.getPackageRegistry(), hierarchyManager);
        }
        catch (ClassNotFoundException e) {
            unprocesseableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Class '" + type.getTypeClassName() + "' not found for type declaration of '" + type.getTypeName() + "'"));
        }
        if (!success) {
            unresolvedTypes.add(new TypeDefinition(type, typeDescr));
        } else {
            this.registerGeneratedType(typeDescr);
        }
    }

    protected void postGenerateDeclaredBean(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, ClassDefinition def, PackageRegistry pkgRegistry) {
    }

    protected void normalizeForeignPackages(PackageDescr packageDescr) {
        HashMap<String, PackageDescr> foreignPackages = null;
        for (AbstractClassTypeDeclarationDescr typeDescr : packageDescr.getClassAndEnumDeclarationDescrs()) {
            PackageDescr altDescr;
            if (!this.kbuilder.filterAccepts(ResourceChange.Type.DECLARATION, typeDescr.getNamespace(), typeDescr.getTypeName()) || typeDescr.getNamespace().equals(packageDescr.getNamespace())) continue;
            if (foreignPackages == null) {
                foreignPackages = new HashMap<String, PackageDescr>();
            }
            if (foreignPackages.containsKey(typeDescr.getNamespace())) {
                altDescr = (PackageDescr)foreignPackages.get(typeDescr.getNamespace());
            } else {
                altDescr = new PackageDescr(typeDescr.getNamespace());
                altDescr.setResource(packageDescr.getResource());
                foreignPackages.put(typeDescr.getNamespace(), altDescr);
            }
            if (typeDescr instanceof TypeDeclarationDescr) {
                altDescr.addTypeDeclaration((TypeDeclarationDescr)typeDescr);
            } else if (typeDescr instanceof EnumDeclarationDescr) {
                altDescr.addEnumDeclaration((EnumDeclarationDescr)typeDescr);
            }
            for (ImportDescr imp : packageDescr.getImports()) {
                altDescr.addImport(imp);
            }
            this.kbuilder.getOrCreatePackageRegistry(altDescr);
        }
    }
}

