/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps;

import java.time.Duration;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomePerspective
extends AbstractPerspective {
    private static final Logger LOG = LoggerFactory.getLogger(HomePerspective.class);
    private static final By HOME_CONTENT = By.className((String)"kie-page");
    private static final int DEFAULT_HOME_PERSP_LOADING_TIMEOUT_SECONDS = 15;
    private static final int HOME_PERSP_LOADING_TIMEOUT_SECONDS = HomePerspective.getTimeoutSeconds();

    @Override
    public void waitForLoaded() {
        long start = System.currentTimeMillis();
        Waits.elementPresent(HOME_CONTENT, HOME_PERSP_LOADING_TIMEOUT_SECONDS);
        long homePageLoadingDurationMillis = System.currentTimeMillis() - start;
        Duration loadingDuration = Duration.ofMillis(homePageLoadingDurationMillis);
        LOG.info("It took {} seconds to load home page.", (Object)loadingDuration.getSeconds());
    }

    @Override
    public boolean isDisplayed() {
        try {
            Waits.elementPresent(HOME_CONTENT, 2);
            return true;
        }
        catch (NoSuchElementException nse) {
            return false;
        }
    }

    private static int getTimeoutSeconds() {
        String timeout = System.getProperty("selenium.homepage.loading.timeout.seconds");
        try {
            return Integer.parseInt(timeout);
        }
        catch (NumberFormatException nfe) {
            return 15;
        }
    }
}

