/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.ui;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.wb.selenium.model.KieSeleniumTest;
import org.kie.wb.selenium.model.persps.ArtifactRepositoryPerspective;
import org.kie.wb.selenium.model.persps.ProjectLibraryPerspective;
import org.kie.wb.selenium.util.Repository;
import org.kie.wb.selenium.util.Waits;

public class ProjectLibraryIntegrationTest
extends KieSeleniumTest {
    private ProjectLibraryPerspective projectLibrary;

    @Before
    public void setUp() {
        this.login.get();
        if (this.login.isDisplayed()) {
            this.login.loginDefaultUser();
        }
        this.projectLibrary = this.home.getNavbar().projects();
        this.projectLibrary.enterDefaultSpace();
    }

    @Test
    public void importAndBuildProjectFromStockRepository() {
        String projectName = "OptaCloud";
        String projectGav = "optacloud:optacloud:1.0.0-SNAPSHOT";
        this.importBuildDeployAndCheckArtifact("optacloud:optacloud:1.0.0-SNAPSHOT", () -> this.projectLibrary.importStockExampleProject(new String[]{"OptaCloud"}));
    }

    @Test
    public void importAndBuildProjectFromCustomRepository() {
        String projectName = "Evaluation";
        String projectGav = "org.jbpm:Evaluation:1.0";
        this.importBuildDeployAndCheckArtifact("org.jbpm:Evaluation:1.0", () -> this.projectLibrary.importCustomExampleProject(Repository.JBPM_PLAYGROUND, new String[]{"Evaluation"}));
    }

    private void importBuildDeployAndCheckArtifact(String projectGav, Runnable stepsToImportProject) {
        stepsToImportProject.run();
        Waits.pause((int)5000);
        this.deployAndCheckArtifact(projectGav);
        this.home.logout();
    }

    private void deployAndCheckArtifact(String artifact) {
        this.projectLibrary.buildAndDeployProject();
        Waits.pause((int)10000);
        ArtifactRepositoryPerspective artifactRepo = this.projectLibrary.getNavbar().admin().artifactRepository();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)artifactRepo.isArtifactPresent(artifact)).as("Project artifact should be present after Build & Deploy", new Object[0])).isTrue();
    }
}

