/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.websocket;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.kie.wb.test.rest.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class WebSocketAccessIntegrationTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketAccessIntegrationTest.class);
    private static final String CONTROLLER_URL = System.getProperty("kie.controller.url", "ws://localhost:8080/business-central/websocket/controller");
    private User user;
    private KieServerControllerClient client;

    public WebSocketAccessIntegrationTest(User user) {
        this.user = user;
    }

    @Parameterized.Parameters(name="user: {0}")
    public static Collection<Object[]> remoteController() {
        return Arrays.asList({User.NO_REST}, {User.REST_ALL});
    }

    @After
    public void close() {
        if (this.client != null) {
            try {
                LOGGER.info("Closing Kie Server Management Controller client");
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error trying to close Kie Server Management Controller Client: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Test
    public void testControllerConnection() {
        if (this.user.isAuthorized()) {
            this.client = KieServerControllerClientFactory.newWebSocketClient((String)CONTROLLER_URL, (String)this.user.getUserName(), (String)this.user.getPassword());
        } else {
            try {
                this.client = KieServerControllerClientFactory.newWebSocketClient((String)CONTROLLER_URL, (String)this.user.getUserName(), (String)this.user.getPassword());
                Assertions.fail((String)"Operation should have failed");
            }
            catch (Exception ex) {
                Assertions.assertThat((Throwable)ex).hasMessageContaining("403");
            }
        }
    }
}

