/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.security;

import org.guvnor.rest.client.CloneProjectRequest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.wb.test.rest.AccessRestTestBase;
import org.kie.wb.test.rest.User;

@RunWith(value=Parameterized.class)
public class RepositoryAccessIntegrationTest
extends AccessRestTestBase {
    private static final String SPACE_NAME = "repositoryAccessTestSpace";

    public RepositoryAccessIntegrationTest(User user) {
        super(user);
    }

    @BeforeClass
    public static void createSpace() {
        RepositoryAccessIntegrationTest.createSpace(SPACE_NAME);
    }

    @Test
    public void testCloneRepository() {
        CloneProjectRequest cloneProjectRequest = new CloneProjectRequest();
        cloneProjectRequest.setName("cloneRepositoryWith" + this.user.getUserName());
        cloneProjectRequest.setGitURL(RepositoryAccessIntegrationTest.getLocalGitRepositoryUrl());
        this.assertOperation(() -> this.roleClient.cloneRepository(SPACE_NAME, cloneProjectRequest));
    }

    @Test
    public void testGetRepository() {
        String name = "getRepositoryWith" + this.user.getUserName();
        RepositoryAccessIntegrationTest.createNewProject(SPACE_NAME, name, "org.myteam", "1.1.0");
        this.assertOperation(() -> this.roleClient.getProject(SPACE_NAME, name));
    }
}

