/*
 * Decompiled with CFR 0.152.
 */
package org.kie.bc.client.perspectives.standalone;

import javax.enterprise.event.Event;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.bc.client.perspectives.standalone.AuthoringPerspective;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.promise.Promises;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthoringPerspectiveTest {
    @Mock
    private PlaceManager placeManager;
    @Mock
    private VFSService vfsServices;
    private Caller<VFSService> vfsServicesCaller;
    @Mock
    private EventSourceMock<WorkspaceProjectContextChangeEvent> workspaceProjectContextChangeEvent;
    @Mock
    private WorkspaceProjectService workspaceProjectService;
    private Caller<WorkspaceProjectService> workspaceProjectServiceCaller;
    @Mock
    private ProjectController projectController;
    private Promises promises;
    @Mock
    private Event<NotificationEvent> notificationEvent;
    private AuthoringPerspective authoringPerspective;

    @Before
    public void setup() {
        this.vfsServicesCaller = new CallerMock((Object)this.vfsServices);
        this.workspaceProjectServiceCaller = new CallerMock((Object)this.workspaceProjectService);
        this.promises = new SyncPromises();
        this.authoringPerspective = (AuthoringPerspective)Mockito.spy((Object)new AuthoringPerspective(this.placeManager, this.vfsServicesCaller, this.workspaceProjectContextChangeEvent, this.workspaceProjectServiceCaller, this.projectController, this.promises, this.notificationEvent));
    }

    @Test
    public void onOpenTest() {
        Path path = (Path)Mockito.mock(Path.class);
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        this.authoringPerspective.projectPathString = "git://master@MySpace/MyProject/src/main/java/com/myspace/myproject/myasset.java";
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)true)).when((Object)this.projectController)).canReadBranch(workspaceProject);
        ((VFSService)Mockito.doReturn((Object)true).when((Object)this.vfsServices)).isRegularFile(this.authoringPerspective.projectPathString);
        ((VFSService)Mockito.doReturn((Object)path).when((Object)this.vfsServices)).get(this.authoringPerspective.projectPathString);
        ((WorkspaceProjectService)Mockito.doReturn((Object)workspaceProject).when((Object)this.workspaceProjectService)).resolveProject(path);
        this.authoringPerspective.onOpen();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closeAllPlaces();
        ((EventSourceMock)Mockito.verify(this.workspaceProjectContextChangeEvent)).fire((Object)new WorkspaceProjectContextChangeEvent(workspaceProject));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((Path)Mockito.same((Object)path));
    }

    @Test
    public void onOpenWithoutPermissionTest() {
        Path path = (Path)Mockito.mock(Path.class);
        this.authoringPerspective.projectPathString = "git://master@MySpace/MyProject/src/main/java/com/myspace/myproject/myasset.java";
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).canReadBranch((WorkspaceProject)Mockito.any());
        ((VFSService)Mockito.doReturn((Object)true).when((Object)this.vfsServices)).isRegularFile(this.authoringPerspective.projectPathString);
        ((VFSService)Mockito.doReturn((Object)path).when((Object)this.vfsServices)).get(this.authoringPerspective.projectPathString);
        ((AuthoringPerspective)Mockito.doReturn((Object)"AssetAccessDenied").when((Object)this.authoringPerspective)).getAssetAccessDeniedMessage();
        this.authoringPerspective.onOpen();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closeAllPlaces();
        ((Event)Mockito.verify(this.notificationEvent)).fire((Object)new NotificationEvent("AssetAccessDenied", NotificationEvent.NotificationType.ERROR));
        ((EventSourceMock)Mockito.verify(this.workspaceProjectContextChangeEvent, (VerificationMode)Mockito.never())).fire(Mockito.any());
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
    }
}

