/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout;

import java.util.Objects;

public final class Vertex
implements Comparable<Vertex> {
    private final String id;
    private double median;
    private boolean isVirtual;
    private int x;
    private int y;

    public Vertex(String id) {
        this(id, false);
    }

    public Vertex(String id, boolean isVirtual) {
        this.id = id;
        this.isVirtual = isVirtual;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    private void setVirtual(boolean virtual) {
        this.isVirtual = virtual;
    }

    private double getMedian() {
        return this.median;
    }

    public void setMedian(double median) {
        this.median = median;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getId() {
        return this.id;
    }

    public Vertex clone() {
        Vertex clone = new Vertex(this.id);
        clone.setMedian(this.median);
        clone.setVirtual(this.isVirtual);
        clone.setX(this.x);
        clone.setY(this.y);
        return clone;
    }

    @Override
    public int compareTo(Vertex other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.getMedian() < other.getMedian()) {
            return -1;
        }
        if (this.getMedian() > other.getMedian()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex vertex = (Vertex)o;
        return this.median == vertex.median && Objects.equals(this.id, vertex.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.median);
    }

    public String toString() {
        return "Vertex{id='" + this.id + '\'' + ", median=" + this.median + ", isVirtual=" + this.isVirtual + ", x=" + this.x + ", y=" + this.y + '}';
    }
}

