/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kie.soup.project.datamodel.commons.oracle.ModuleDataModelOracleImpl;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassToGenericClassConverter;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.JavaTypeSystemTranslator;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ModuleDataModelOracleBuilder;

public abstract class BaseFactBuilder
implements FactBuilder {
    protected final ModuleDataModelOracleBuilder builder;
    protected final Function<String, TypeSource> typeSourceResolver;
    private final String type;
    private final List<ModelField> fields = new ArrayList<ModelField>();
    private final boolean isCollection;
    private final boolean isEvent;
    protected final ClassToGenericClassConverter typeSystemConverter = new JavaTypeSystemTranslator();

    public BaseFactBuilder(ModuleDataModelOracleBuilder builder, Class<?> clazz, boolean isEvent, Function<String, TypeSource> typeSourceResolver) {
        this.builder = builder;
        this.type = this.getFullClassName(clazz);
        this.isCollection = this.isCollection(clazz);
        this.isEvent = isEvent;
        this.typeSourceResolver = typeSourceResolver;
        this.addField(new ModelField("this", this.type, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, this.typeSystemConverter.translateClassToGenericType(clazz)));
    }

    public BaseFactBuilder(ModuleDataModelOracleBuilder builder, String type, boolean isCollection, boolean isEvent, Function<String, TypeSource> typeSourceResolver) {
        this.builder = builder;
        this.type = type;
        this.isCollection = isCollection;
        this.isEvent = isEvent;
        this.typeSourceResolver = typeSourceResolver;
        this.addField(new ModelField("this", type, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, type));
    }

    private boolean isCollection(Class<?> clazz) {
        return clazz != null && Collection.class.isAssignableFrom(clazz);
    }

    private String getFullClassName(Class<?> clazz) {
        return clazz.getName();
    }

    public String getType() {
        return this.type;
    }

    protected FactBuilder addField(ModelField field) {
        this.fields.add(field);
        return this;
    }

    @Override
    public ModuleDataModelOracleBuilder end() {
        return this.builder;
    }

    @Override
    public void build(ModuleDataModelOracleImpl oracle) {
        oracle.addModuleModelFields(this.buildModelFields());
        oracle.addModuleCollectionTypes(this.buildCollectionTypes());
        oracle.addModuleEventTypes(this.buildEventTypes());
        oracle.addModuleTypeSources(this.buildTypeSources());
    }

    public ModuleDataModelOracleBuilder getDataModelBuilder() {
        return this.builder;
    }

    private Map<String, ModelField[]> buildModelFields() {
        HashMap<String, ModelField[]> loadableFactsAndFields = new HashMap<String, ModelField[]>();
        ModelField[] loadableFields = new ModelField[this.fields.size()];
        this.fields.toArray(loadableFields);
        loadableFactsAndFields.put(this.type, loadableFields);
        return loadableFactsAndFields;
    }

    private Map<String, Boolean> buildCollectionTypes() {
        HashMap<String, Boolean> loadableCollectionTypes = new HashMap<String, Boolean>();
        loadableCollectionTypes.put(this.type, this.isCollection);
        return loadableCollectionTypes;
    }

    private Map<String, Boolean> buildEventTypes() {
        HashMap<String, Boolean> loadableEventTypes = new HashMap<String, Boolean>();
        loadableEventTypes.put(this.type, this.isEvent);
        return loadableEventTypes;
    }

    private Map<String, TypeSource> buildTypeSources() {
        HashMap<String, TypeSource> loadableTypeSources = new HashMap<String, TypeSource>();
        loadableTypeSources.put(this.type, this.typeSourceResolver.apply(this.type));
        return loadableTypeSources;
    }
}

