/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.fluent;

import java.util.Objects;
import java.util.Optional;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.command.RegistryContext;

public abstract class AbstractDMNModelCommand
implements ExecutableCommand<DMNModel> {
    protected String namespace;
    protected String modelName;
    protected String resourcePath;

    public AbstractDMNModelCommand(String namespace, String modelName) {
        this.namespace = Objects.requireNonNull(namespace, "namespace cannot be null");
        this.modelName = Objects.requireNonNull(modelName, "modelName cannot be null");
    }

    public AbstractDMNModelCommand(String resourcePath) {
        this.resourcePath = Objects.requireNonNull(resourcePath, "resource cannot be null");
    }

    protected DMNModel getDMNModel(Context context) {
        RegistryContext registryContext = (RegistryContext)context;
        DMNRuntime dmnRuntime = (DMNRuntime)registryContext.lookup(DMNRuntime.class);
        if (dmnRuntime == null) {
            throw new IllegalStateException("There is no DMNRuntime available");
        }
        return this.retrieveDMNModel(dmnRuntime);
    }

    protected DMNModel retrieveDMNModel(DMNRuntime dmnRuntime) {
        if (this.namespace != null && this.modelName != null) {
            return Optional.ofNullable(dmnRuntime.getModel(this.namespace, this.modelName)).orElseThrow(() -> new IllegalStateException("Cannot find a DMN model with namespace=" + this.namespace + " and modelName=" + this.modelName));
        }
        if (this.resourcePath != null) {
            return dmnRuntime.getModels().stream().filter(model -> Objects.equals(this.resourcePath, model.getResource().getSourcePath())).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find a DMN model with resource=" + this.resourcePath));
        }
        throw new IllegalStateException("Both resourcePath and namespace+modelName are not set, this should not happen");
    }
}

