/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.calendar;

import com.google.api.services.calendar.Calendar;
import java.io.IOException;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.google.calendar.GoogleCalendarAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="GoogleAddCalendarDefinitions.wid", name="GoogleAddCalendar", displayName="GoogleAddCalendar", defaultHandler="mvel: new org.jbpm.process.workitem.google.calendar.AddCalendarWorkitemHandler(\"appName\", \"clentSecret\")", documentation="google-calendar-workitem/index.html", category="google-calendar-workitem", icon="GoogleAddCalendar.png", parameters={@WidParameter(name="CalendarSummary", required=true)}, results={@WidResult(name="Calendar", runtimeType="com.google.api.services.calendar.model.Calendar")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-calendar-workitem", version="7.27.0.Final")}, serviceInfo=@WidService(category="Google Calendar", description="Add and retrieve Calendars and Calendar Events from Google", keywords="google,calendar,add", action=@WidAction(title="Add a new Google Calendar"), authinfo=@WidAuth(required=true, params={"appName", "clentSecret"}, paramsdescription={"Google app name", "Google client secret"}, referencesite="https://developers.google.com/calendar/auth")))
public class AddCalendarWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final String RESULTS_CALENDAR = "Calendar";
    private String appName;
    private String clientSecret;
    private GoogleCalendarAuth auth = new GoogleCalendarAuth();

    public AddCalendarWorkitemHandler(String appName, String clentSecret) {
        this.appName = appName;
        this.clientSecret = clentSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, com.google.api.services.calendar.model.Calendar> results = new HashMap<String, com.google.api.services.calendar.model.Calendar>();
        String paramCalendarSummary = (String)workItem.getParameter("CalendarSummary");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Calendar client = this.auth.getAuthorizedCalendar(this.appName, this.clientSecret);
            results.put(RESULTS_CALENDAR, this.addCalendar(client, paramCalendarSummary));
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public com.google.api.services.calendar.model.Calendar addCalendar(Calendar client, String calendarSummary) throws IOException {
        com.google.api.services.calendar.model.Calendar entry = new com.google.api.services.calendar.model.Calendar();
        entry.setSummary(calendarSummary);
        return (com.google.api.services.calendar.model.Calendar)client.calendars().insert(entry).execute();
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleCalendarAuth auth) {
        this.auth = auth;
    }
}

