/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.registry.impl;

import java.util.Stack;
import org.kie.workbench.common.stunner.core.registry.DynamicRegistry;
import org.kie.workbench.common.stunner.core.registry.impl.KeyProvider;

class StackRegistry<T>
implements DynamicRegistry<T> {
    private final KeyProvider<T> keyProvider;
    private final Stack<T> items;

    public StackRegistry(KeyProvider<T> keyProvider, Stack<T> items) {
        this.keyProvider = keyProvider;
        this.items = items;
    }

    public T peek() {
        return this.items.peek();
    }

    public T pop() {
        return this.items.pop();
    }

    public void register(T item) {
        this.items.add(item);
    }

    public boolean remove(T item) {
        return this.items.remove(item);
    }

    public boolean contains(T item) {
        return this.items.contains(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public T getItemByKey(String id) {
        if (null != id) {
            for (Object item : this.items) {
                String itemId = this.getItemKey(item);
                if (!id.equals(itemId)) continue;
                return (T)item;
            }
        }
        return null;
    }

    public int indexOf(T item) {
        return this.items.indexOf(item);
    }

    private String getItemKey(T item) {
        return this.keyProvider.getKey(item);
    }

    Stack<T> getStack() {
        return this.items;
    }
}

