/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.backend.server;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.jbpm.workbench.ht.model.TaskAssignmentSummary;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.instance.TaskInstance;

public class TaskAssignmentSummaryMapper
implements BiFunction<TaskInstance, IdentityProvider, TaskAssignmentSummary> {
    @Override
    public TaskAssignmentSummary apply(TaskInstance task, IdentityProvider identityProvider) {
        if (task == null) {
            return null;
        }
        TaskAssignmentSummary summary = new TaskAssignmentSummary();
        summary.setTaskId(task.getId());
        summary.setActualOwner(task.getActualOwner());
        summary.setTaskName(task.getName());
        summary.setPotOwnersString(task.getPotentialOwners());
        summary.setCreatedBy(task.getCreatedBy());
        summary.setBusinessAdmins(task.getBusinessAdmins());
        summary.setStatus(task.getStatus());
        summary.setDelegationAllowed(this.isDelegationAllowed(task, identityProvider));
        summary.setForwardAllowed(this.isForwardAllowed(task, identityProvider));
        summary.setDeploymentId(task.getContainerId());
        return summary;
    }

    protected Boolean isForwardAllowed(TaskInstance task, IdentityProvider identityProvider) {
        if ("Completed".equals(task.getStatus())) {
            return false;
        }
        String actualOwner = task.getActualOwner();
        if (actualOwner != null && actualOwner.equals(identityProvider.getName())) {
            return true;
        }
        List roles = identityProvider.getRoles();
        List potentialOwners = task.getPotentialOwners();
        if (potentialOwners != null && !Collections.disjoint(potentialOwners, roles)) {
            return true;
        }
        List businessAdministrators = task.getBusinessAdmins();
        if (businessAdministrators != null && !Collections.disjoint(businessAdministrators, roles)) {
            return true;
        }
        return false;
    }

    protected Boolean isDelegationAllowed(TaskInstance task, IdentityProvider identityProvider) {
        if ("Completed".equals(task.getStatus())) {
            return false;
        }
        String actualOwner = task.getActualOwner();
        if (actualOwner != null && actualOwner.equals(identityProvider.getName())) {
            return true;
        }
        String initiator = task.getCreatedBy();
        if (initiator != null && initiator.equals(identityProvider.getName())) {
            return true;
        }
        List roles = identityProvider.getRoles();
        List potentialOwners = task.getPotentialOwners();
        if (potentialOwners != null && !Collections.disjoint(potentialOwners, roles)) {
            return true;
        }
        List businessAdministrators = task.getBusinessAdmins();
        if (businessAdministrators != null && !Collections.disjoint(businessAdministrators, roles)) {
            return true;
        }
        return false;
    }
}

