/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.VariableDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;

public interface VariableScope {
    public Variable declare(String var1, String var2, String var3);

    public Optional<Variable> lookup(String var1);

    public Variable declare(String var1, String var2, String var3, String var4);

    public Collection<Variable> getVariables(String var1);

    public static class Variable {
        String parentScopeId;
        VariableDeclaration declaration;
        ItemDefinition typeDeclaration;
        Property typedIdentifier;
        String kpi;

        Variable(String parentScopeId, String identifier, String type) {
            this.parentScopeId = parentScopeId;
            this.declaration = new VariableDeclaration(identifier, type);
            this.typeDeclaration = Factories.bpmn2.createItemDefinition();
            this.typeDeclaration.setId(Ids.item(identifier));
            this.typeDeclaration.setStructureRef(type);
            this.typedIdentifier = Factories.bpmn2.createProperty();
            this.typedIdentifier.setId(Ids.typedIdentifier(parentScopeId, identifier));
            this.typedIdentifier.setName(identifier);
            this.typedIdentifier.setItemSubjectRef(this.typeDeclaration);
        }

        Variable(String parentScopeId, String identifier, String type, String kpi) {
            this(parentScopeId, identifier, type);
            this.kpi = kpi;
        }

        public ItemDefinition getTypeDeclaration() {
            return this.typeDeclaration;
        }

        public Property getTypedIdentifier() {
            return this.typedIdentifier;
        }

        public String getParentScopeId() {
            return this.parentScopeId;
        }
    }
}

