/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.entrypoint;

import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLTextAreaElement;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.client.util.Clipboard;
import org.uberfire.ext.editor.commons.client.file.popups.elemental2.Elemental2Modal;
import org.uberfire.workbench.events.NotificationEvent;

@Templated
@ApplicationScoped
public class GenericErrorPopup
extends Elemental2Modal<GenericErrorPopup>
implements Elemental2Modal.View<GenericErrorPopup> {
    @Inject
    @DataField(value="header")
    private HTMLDivElement header;
    @Inject
    @DataField(value="body")
    private HTMLDivElement body;
    @Inject
    @DataField(value="footer")
    private HTMLDivElement footer;
    @Inject
    @DataField(value="ignore-button")
    private HTMLButtonElement ignoreButton;
    @Inject
    @DataField(value="copy-details-button")
    private HTMLButtonElement copyDetailsButton;
    @Inject
    @DataField(value="error-details")
    private HTMLTextAreaElement errorDetails;
    @Inject
    private Event<NotificationEvent> notificationEvent;
    private final Clipboard clipboard;

    @Inject
    public GenericErrorPopup(GenericErrorPopup view, Clipboard clipboard) {
        super((Elemental2Modal.View)view);
        this.clipboard = clipboard;
    }

    @PostConstruct
    public void init() {
        super.setup();
        this.getModal().addHiddenHandler(e -> {
            this.errorDetails.textContent = "";
        });
    }

    public void init(GenericErrorPopup this_) {
    }

    public void setup(String details) {
        this.errorDetails.textContent = this.isShowing() ? this.errorDetails.textContent + " | " + details : details;
    }

    @EventHandler(value={"ignore-button"})
    private void onIgnoreButtonClicked(@ForEvent(value={"click"}) elemental2.dom.Event e) {
        DomGlobal.console.error(new Object[]{this.errorDetails.textContent});
        this.hide();
    }

    @EventHandler(value={"copy-details-button"})
    private void onCopyDetailsButtonClicked(@ForEvent(value={"click"}) elemental2.dom.Event e) {
        boolean copySucceeded = this.clipboard.copy(this.errorDetails);
        if (copySucceeded) {
            this.notificationEvent.fire((Object)new NotificationEvent(DefaultWorkbenchConstants.INSTANCE.ErrorDetailsSuccessfullyCopiedToClipboard(), NotificationEvent.NotificationType.SUCCESS));
        } else {
            this.notificationEvent.fire((Object)new NotificationEvent(DefaultWorkbenchConstants.INSTANCE.ErrorDetailsFailedToBeCopiedToClipboard(), NotificationEvent.NotificationType.WARNING));
        }
        DomGlobal.console.error(new Object[]{this.errorDetails.textContent});
        this.hide();
    }

    public String getHeader() {
        return this.header.textContent;
    }

    public HTMLElement getBody() {
        return this.body;
    }

    public HTMLElement getFooter() {
        return this.footer;
    }
}

