/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.definition;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.ParallelGateway;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.definition.annotation.PropertySet;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Category;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Labels;
import org.kie.workbench.common.stunner.core.definition.annotation.morph.MorphBase;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@MorphBase(defaultType=ParallelGateway.class)
public abstract class BaseGateway
implements BPMNViewDefinition {
    @Category
    public static final transient String category = "Gateways";
    @PropertySet
    @FormField
    @Valid
    protected BPMNGeneralSet general;
    @PropertySet
    @Valid
    protected BackgroundSet backgroundSet;
    @PropertySet
    protected FontSet fontSet;
    @PropertySet
    protected CircleDimensionSet dimensionsSet;
    @Labels
    protected final Set<String> labels = new HashSet<String>();

    public BaseGateway() {
        this.initLabels();
    }

    public BaseGateway(BPMNGeneralSet general, BackgroundSet backgroundSet, FontSet fontSet, CircleDimensionSet dimensionsSet) {
        this();
        this.general = general;
        this.backgroundSet = backgroundSet;
        this.fontSet = fontSet;
        this.dimensionsSet = dimensionsSet;
    }

    protected void initLabels() {
        this.labels.add("all");
        this.labels.add("lane_child");
        this.labels.add("sequence_start");
        this.labels.add("sequence_end");
        this.labels.add("choreography_sequence_start");
        this.labels.add("choreography_sequence_end");
        this.labels.add("fromtoall");
        this.labels.add("GatewaysMorph");
        this.labels.add("cm_nop");
    }

    public String getCategory() {
        return category;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    @Override
    public BPMNGeneralSet getGeneral() {
        return this.general;
    }

    @Override
    public BackgroundSet getBackgroundSet() {
        return this.backgroundSet;
    }

    @Override
    public FontSet getFontSet() {
        return this.fontSet;
    }

    public void setGeneral(BPMNGeneralSet general) {
        this.general = general;
    }

    public void setBackgroundSet(BackgroundSet backgroundSet) {
        this.backgroundSet = backgroundSet;
    }

    public void setFontSet(FontSet fontSet) {
        this.fontSet = fontSet;
    }

    public CircleDimensionSet getDimensionsSet() {
        return this.dimensionsSet;
    }

    public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        this.dimensionsSet = dimensionsSet;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{Objects.hashCode(this.getClass()), Objects.hashCode(this.general), Objects.hashCode(this.backgroundSet), Objects.hashCode(this.fontSet), Objects.hashCode(this.dimensionsSet), Objects.hashCode(this.labels)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BaseGateway) {
            BaseGateway other = (BaseGateway)o;
            return Objects.equals(this.general, other.general) && Objects.equals(this.backgroundSet, other.backgroundSet) && Objects.equals(this.fontSet, other.fontSet) && Objects.equals(this.dimensionsSet, other.dimensionsSet) && Objects.equals(this.labels, other.labels);
        }
        return false;
    }
}

