/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class Merge {
    private Logger logger = LoggerFactory.getLogger(Merge.class);
    private final Git git;
    private final String sourceBranch;
    private final String targetBranch;

    public Merge(Git git, String sourceBranch, String targetBranch) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.sourceBranch = PortablePreconditions.checkNotEmpty((String)"sourceBranch", (String)sourceBranch);
        this.targetBranch = PortablePreconditions.checkNotEmpty((String)"targetBranch", (String)targetBranch);
    }

    public List<String> execute() {
        this.existsBranch(this.git, this.sourceBranch);
        this.existsBranch(this.git, this.targetBranch);
        Repository repo = this.git.getRepository();
        RevCommit lastSourceCommit = this.git.getLastCommit(this.sourceBranch);
        RevCommit lastTargetCommit = this.git.getLastCommit(this.targetBranch);
        RevCommit commonAncestor = this.getCommonAncestor((ObjectId)lastSourceCommit, (ObjectId)lastTargetCommit);
        List<RevCommit> commits = this.git.listCommits((ObjectId)commonAncestor, (ObjectId)lastSourceCommit);
        Collections.reverse(commits);
        String[] commitsIDs = (String[])commits.stream().map(AnyObjectId::getName).toArray(String[]::new);
        this.canMerge(repo, commonAncestor, lastSourceCommit, lastTargetCommit, this.sourceBranch, this.targetBranch);
        this.git.cherryPick(this.targetBranch, commitsIDs);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Merging commits from <{}> to <{}>", (Object)this.sourceBranch, (Object)this.targetBranch);
        }
        return Arrays.asList(commitsIDs);
    }

    private void canMerge(Repository repo, RevCommit commonAncestor, RevCommit sourceCommitTree, RevCommit targetCommitTree, String sourceBranch, String targetBranch) {
        try {
            ThreeWayMerger merger = MergeStrategy.RECURSIVE.newMerger(repo, true);
            merger.setBase((AnyObjectId)commonAncestor);
            boolean canMerge = merger.merge(new AnyObjectId[]{sourceCommitTree, targetCommitTree});
            if (!canMerge) {
                throw new GitException(String.format("Cannot merge braches from <%s> to <%s>, merge conflicts", sourceBranch, targetBranch));
            }
        }
        catch (IOException e) {
            throw new GitException(String.format("Cannot merge braches from <%s> to <%s>, merge conflicts", sourceBranch, targetBranch), e);
        }
    }

    private void existsBranch(Git git, String branch) {
        if (git.getRef(branch) == null) {
            throw new GitException(String.format("Branch <<%s>> does not exists", branch));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RevCommit getCommonAncestor(ObjectId rightCommit, ObjectId leftCommit) {
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            RevCommit commitA = revWalk.lookupCommit((AnyObjectId)rightCommit);
            RevCommit commitB = revWalk.lookupCommit((AnyObjectId)leftCommit);
            revWalk.setRevFilter(RevFilter.MERGE_BASE);
            revWalk.markStart(commitA);
            revWalk.markStart(commitB);
            RevCommit revCommit = revWalk.next();
            return revCommit;
        }
        catch (Exception e) {
            throw new GitException("Problem when trying to get common ancestor", e);
        }
    }
}

