/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.drools.core.util.ClassUtils;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.visitor.DrlGenericVisitor;
import org.drools.mvelcompiler.ast.BinaryTExpr;
import org.drools.mvelcompiler.ast.CastExprT;
import org.drools.mvelcompiler.ast.CharacterLiteralExpressionT;
import org.drools.mvelcompiler.ast.FieldAccessTExpr;
import org.drools.mvelcompiler.ast.FieldToAccessorTExpr;
import org.drools.mvelcompiler.ast.IntegerLiteralExpressionT;
import org.drools.mvelcompiler.ast.ListAccessExprT;
import org.drools.mvelcompiler.ast.MethodCallExprT;
import org.drools.mvelcompiler.ast.ObjectCreationExpressionT;
import org.drools.mvelcompiler.ast.SimpleNameTExpr;
import org.drools.mvelcompiler.ast.StringLiteralExpressionT;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.ast.UnalteredTypedExpression;
import org.drools.mvelcompiler.context.Declaration;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.drools.mvelcompiler.util.OptionalUtils;

public class RHSPhase
implements DrlGenericVisitor<TypedExpression, Context> {
    private final MvelCompilerContext mvelCompilerContext;

    RHSPhase(MvelCompilerContext mvelCompilerContext) {
        this.mvelCompilerContext = mvelCompilerContext;
    }

    public TypedExpression invoke(Statement statement) {
        Context ctx = new Context(null);
        return (TypedExpression)statement.accept((GenericVisitor)this, (Object)ctx);
    }

    public TypedExpression visit(DrlNameExpr n, Context arg) {
        return (TypedExpression)n.getName().accept((GenericVisitor)this, (Object)arg);
    }

    public TypedExpression visit(SimpleName n, Context arg) {
        if (!arg.scope.isPresent()) {
            return this.simpleNameAsFirstNode(n);
        }
        return this.simpleNameAsField(n, arg);
    }

    private TypedExpression simpleNameAsFirstNode(SimpleName n) {
        return this.asDeclaration(n).map(Optional::of).orElseGet(() -> this.asEnum(n)).orElseGet(() -> new UnalteredTypedExpression((Node)n));
    }

    private TypedExpression simpleNameAsField(SimpleName n, Context arg) {
        return this.asPropertyAccessor(n, arg).map(Optional::of).orElseGet(() -> this.asFieldAccessTExpr(n, arg)).orElseGet(() -> new UnalteredTypedExpression((Node)n));
    }

    private Optional<TypedExpression> asFieldAccessTExpr(SimpleName n, Context arg) {
        Optional<TypedExpression> lastTypedExpression = arg.scope;
        Optional<Type> scopeType = arg.getScopeType();
        Optional fieldType = scopeType.flatMap(te -> {
            Class parentClass = (Class)te;
            Field field = ClassUtils.getField((Class)parentClass, (String)n.asString());
            return Optional.ofNullable(field);
        });
        return OptionalUtils.map2(lastTypedExpression, fieldType, FieldAccessTExpr::new);
    }

    private Optional<TypedExpression> asDeclaration(SimpleName n) {
        Optional<Declaration> typeFromDeclarations = this.mvelCompilerContext.findDeclarations(n.asString());
        return typeFromDeclarations.map(d -> {
            Class<?> clazz = d.getClazz();
            return new SimpleNameTExpr(n.asString(), clazz);
        });
    }

    private Optional<TypedExpression> asEnum(SimpleName n) {
        Optional<Class<?>> enumType = this.mvelCompilerContext.findEnum(n.asString());
        return enumType.map(clazz -> new SimpleNameTExpr(n.asString(), (Class<?>)clazz));
    }

    private Optional<TypedExpression> asPropertyAccessor(SimpleName n, Context arg) {
        Optional<TypedExpression> lastTypedExpression = arg.scope;
        Optional<Type> scopeType = arg.getScopeType();
        Optional optAccessor = scopeType.flatMap(t -> Optional.ofNullable(ClassUtils.getAccessor((Class)((Class)t), (String)n.asString())));
        return OptionalUtils.map2(lastTypedExpression, optAccessor, FieldToAccessorTExpr::new);
    }

    public TypedExpression visit(FieldAccessExpr n, Context arg) {
        TypedExpression scope = (TypedExpression)n.getScope().accept((GenericVisitor)this, (Object)arg);
        return (TypedExpression)n.getName().accept((GenericVisitor)this, (Object)new Context(scope));
    }

    public TypedExpression visit(MethodCallExpr n, Context arg) {
        Optional<TypedExpression> scope = n.getScope().map(s -> (TypedExpression)s.accept((GenericVisitor)this, (Object)arg));
        TypedExpression name = (TypedExpression)n.getName().accept((GenericVisitor)this, (Object)new Context(scope.orElse(null)));
        ArrayList<TypedExpression> arguments = new ArrayList<TypedExpression>(n.getArguments().size());
        for (Expression child : n.getArguments()) {
            TypedExpression a = (TypedExpression)child.accept((GenericVisitor)this, (Object)arg);
            arguments.add(a);
        }
        return new MethodCallExprT(n.getName().asString(), scope, arguments, name.getType());
    }

    public TypedExpression visit(BinaryExpr n, Context arg) {
        TypedExpression left = (TypedExpression)n.getLeft().accept((GenericVisitor)this, (Object)arg);
        TypedExpression right = (TypedExpression)n.getRight().accept((GenericVisitor)this, (Object)arg);
        return new BinaryTExpr(left, right, n.getOperator());
    }

    public TypedExpression visit(ExpressionStmt n, Context arg) {
        return (TypedExpression)n.getExpression().accept((GenericVisitor)this, (Object)arg);
    }

    public TypedExpression visit(VariableDeclarationExpr n, Context arg) {
        return (TypedExpression)((VariableDeclarator)n.getVariables().iterator().next()).accept((GenericVisitor)this, (Object)arg);
    }

    public TypedExpression visit(VariableDeclarator n, Context arg) {
        Optional<TypedExpression> initExpression = n.getInitializer().map(i -> (TypedExpression)i.accept((GenericVisitor)this, (Object)arg));
        return initExpression.orElse(null);
    }

    public TypedExpression visit(AssignExpr n, Context arg) {
        return (TypedExpression)n.getValue().accept((GenericVisitor)this, (Object)arg);
    }

    public TypedExpression visit(StringLiteralExpr n, Context arg) {
        return new StringLiteralExpressionT(n);
    }

    public TypedExpression visit(IntegerLiteralExpr n, Context arg) {
        return new IntegerLiteralExpressionT(n);
    }

    public TypedExpression visit(CharLiteralExpr n, Context arg) {
        return new CharacterLiteralExpressionT(n);
    }

    public TypedExpression defaultMethod(Node n, Context context) {
        return new UnalteredTypedExpression(n);
    }

    public TypedExpression visit(ObjectCreationExpr n, Context arg) {
        return new ObjectCreationExpressionT(n, this.resolveType((com.github.javaparser.ast.type.Type)n.getType()));
    }

    public TypedExpression visit(ArrayAccessExpr n, Context arg) {
        TypedExpression name = (TypedExpression)n.getName().accept((GenericVisitor)this, (Object)arg);
        Optional<Type> type = name.getType();
        if (type.filter(this::isCollection).isPresent()) {
            return new ListAccessExprT(name, n.getIndex(), type.get());
        }
        return new UnalteredTypedExpression((Node)n, type.orElse(null));
    }

    public boolean isCollection(Type t) {
        return Stream.of(List.class, Map.class).anyMatch(cls -> cls.isAssignableFrom((Class)t));
    }

    public TypedExpression visit(EnclosedExpr n, Context arg) {
        return (TypedExpression)n.getInner().accept((GenericVisitor)this, (Object)arg);
    }

    public TypedExpression visit(CastExpr n, Context arg) {
        TypedExpression innerExpr = (TypedExpression)n.getExpression().accept((GenericVisitor)this, (Object)arg);
        return new CastExprT(innerExpr, this.resolveType(n.getType()));
    }

    private Class<?> resolveType(com.github.javaparser.ast.type.Type type) {
        return this.mvelCompilerContext.resolveType(type.asString());
    }

    static class Context {
        final Optional<TypedExpression> scope;

        Context(TypedExpression scope) {
            this.scope = Optional.ofNullable(scope);
        }

        Optional<Type> getScopeType() {
            return this.scope.flatMap(TypedExpression::getType);
        }
    }
}

