/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FormalExpression;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.AdHocSubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocActivationCondition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocCompletionCondition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocOrdering;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseAdHocActivationCondition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseAdHocCompletionCondition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;

public class AdHocSubProcessPropertyWriterTest {
    private AdHocSubProcessPropertyWriter tested = new AdHocSubProcessPropertyWriter(Factories.bpmn2.createAdHocSubProcess(), (VariableScope)new FlatVariableScope());

    @Test
    public void testSetAdHocAutostart_true() throws Exception {
        this.tested.setAdHocAutostart(Boolean.TRUE.booleanValue());
        Assert.assertTrue((boolean)((Boolean)CustomElement.autoStart.of((BaseElement)this.tested.getFlowElement()).get()));
    }

    @Test
    public void testSetAdHocAutostart_false() throws Exception {
        this.tested.setAdHocAutostart(Boolean.FALSE.booleanValue());
        Assert.assertFalse((boolean)((Boolean)CustomElement.autoStart.of((BaseElement)this.tested.getFlowElement()).get()));
    }

    @Test
    public void testSetAdHocActivationCondition() {
        this.tested.setAdHocActivationCondition((BaseAdHocActivationCondition)new AdHocActivationCondition("condition expression"));
        Assert.assertEquals((Object)Scripts.asCData((String)"condition expression"), (Object)CustomElement.customActivationCondition.of((BaseElement)this.tested.getFlowElement()).get());
    }

    @Test
    public void testSetAdHocActivationConditionNull() {
        this.tested.setAdHocActivationCondition((BaseAdHocActivationCondition)new AdHocActivationCondition(null));
        Assert.assertEquals((Object)"", (Object)CustomElement.customActivationCondition.of((BaseElement)this.tested.getFlowElement()).get());
    }

    @Test
    public void testSetAdHocActivationConditionEmpty() {
        this.tested.setAdHocActivationCondition((BaseAdHocActivationCondition)new AdHocActivationCondition(""));
        Assert.assertEquals((Object)"", (Object)CustomElement.customActivationCondition.of((BaseElement)this.tested.getFlowElement()).get());
    }

    @Test
    public void testSetAdHocOrderingSequential() {
        this.tested.setAdHocOrdering(new AdHocOrdering("Sequential"));
        Assert.assertEquals((Object)org.eclipse.bpmn2.AdHocOrdering.SEQUENTIAL, (Object)((AdHocSubProcess)this.tested.getFlowElement()).getOrdering());
    }

    @Test
    public void testSetAdHocOrderingParallel() {
        this.tested.setAdHocOrdering(new AdHocOrdering("Parallel"));
        Assert.assertEquals((Object)org.eclipse.bpmn2.AdHocOrdering.PARALLEL, (Object)((AdHocSubProcess)this.tested.getFlowElement()).getOrdering());
    }

    @Test
    public void testSetAdHocCompletionCondition() {
        AdHocCompletionCondition condition = new AdHocCompletionCondition(new ScriptTypeValue("java", "some code"));
        this.tested.setAdHocCompletionCondition((BaseAdHocCompletionCondition)condition);
        FormalExpression expression = (FormalExpression)((AdHocSubProcess)this.tested.getFlowElement()).getCompletionCondition();
        Assert.assertEquals((Object)condition.getValue().getLanguage(), (Object)Scripts.scriptLanguageFromUri((String)expression.getLanguage()));
        Assert.assertEquals((Object)Scripts.asCData((String)condition.getValue().getScript()), (Object)expression.getBody());
    }

    @Test
    public void testSetAsync() {
        this.tested.setAsync(Boolean.valueOf(true));
        Assert.assertTrue((boolean)((Boolean)CustomElement.async.of((BaseElement)this.tested.getFlowElement()).get()));
    }

    @Test
    public void testSetSlaDueDate() {
        String slaDueDate = "12/25/1983";
        this.tested.setSlaDueDate(new SLADueDate(slaDueDate));
        Assert.assertTrue((boolean)((String)CustomElement.slaDueDate.of((BaseElement)this.tested.getFlowElement()).get()).contains(slaDueDate));
    }
}

