/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.GenericServiceTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.GenericServiceTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GenericServiceTaskPropertyReaderTest {
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final String SLA_DUE_DATE_CDATA = "<![CDATA[12/25/1983]]>";
    private GenericServiceTaskPropertyReader reader;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private DefinitionResolver definitionResolver;

    @Before
    public void setUp() {
        ServiceTask serviceTask = Factories.bpmn2.createServiceTask();
        GenericServiceTaskPropertyWriter writer = new GenericServiceTaskPropertyWriter(serviceTask, null);
        writer.setServiceImplementation("WebService");
        writer.setServiceInterface("setServiceInterface");
        writer.setServiceOperation("setServiceOperation");
        writer.setSLADueDate(SLA_DUE_DATE);
        writer.setAsync(false);
        writer.setAdHocAutostart(true);
        OnEntryAction onEntryAction = new OnEntryAction();
        onEntryAction.setValue(new ScriptTypeListValue());
        writer.setOnEntryAction(onEntryAction);
        OnExitAction onExitAction = new OnExitAction();
        onExitAction.setValue(new ScriptTypeListValue());
        writer.setOnExitAction(onExitAction);
        writer.setAssignmentsInfo(new AssignmentsInfo());
        this.reader = new GenericServiceTaskPropertyReader(serviceTask, this.diagram, this.definitionResolver);
    }

    @Test
    public void getGenericServiceTask() {
        GenericServiceTaskValue task = this.reader.getGenericServiceTask();
        Assert.assertEquals((Object)"setServiceOperation", (Object)task.getServiceOperation());
        Assert.assertEquals((Object)"setServiceInterface", (Object)task.getServiceInterface());
        Assert.assertEquals((Object)"WebService", (Object)task.getServiceImplementation());
        Assert.assertEquals((Object)SLA_DUE_DATE_CDATA, (Object)this.reader.getSLADueDate());
        Assert.assertEquals((Object)false, (Object)this.reader.isAsync());
        Assert.assertEquals((Object)true, (Object)this.reader.isAdHocAutostart());
        Assert.assertNotNull((Object)this.reader.getOnEntryAction());
        Assert.assertNotNull((Object)this.reader.getOnExitAction());
        Assert.assertNotNull((Object)this.reader.getAssignmentsInfo());
    }
}

