/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.service.BPMNDiagramServiceImpl;
import org.kie.workbench.common.stunner.bpmn.service.ProjectType;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class BPMNDiagramServiceImplTest {
    public static final String DIR_URI = "default://master@diagrams/root";
    private static final String FILE_NAME = ".caseproject";
    public static final String FILE_URI = "default://master@diagrams/root/.caseproject";
    private BPMNDiagramServiceImpl tested;
    @Mock
    private IOService ioService;
    @Mock
    private DirectoryStream<Path> directoryStream;
    @Mock
    private org.uberfire.backend.vfs.Path projectPath;
    @Mock
    private Path fsPath;
    @Mock
    private Path fileName;
    @Mock
    private FileSystem fs;

    @Before
    public void setUp() throws Exception {
        ArgumentCaptor filter = ArgumentCaptor.forClass(DirectoryStream.Filter.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Matchers.any(), (DirectoryStream.Filter)filter.capture())).thenReturn(this.directoryStream);
        Mockito.when((Object)this.directoryStream.spliterator()).thenReturn(Arrays.asList(this.fsPath).spliterator());
        Mockito.when((Object)this.projectPath.toURI()).thenReturn((Object)DIR_URI);
        Mockito.when((Object)this.fsPath.getFileName()).thenReturn((Object)this.fileName);
        Mockito.when((Object)this.fsPath.toUri()).thenReturn((Object)new URI(FILE_URI));
        Mockito.when((Object)this.fsPath.getFileSystem()).thenReturn((Object)this.fs);
        Mockito.when((Object)this.fileName.toString()).thenReturn((Object)FILE_NAME);
        this.tested = new BPMNDiagramServiceImpl(this.ioService);
    }

    @Test
    public void getProjectTypeCase() {
        ProjectType projectType = this.tested.getProjectType(this.projectPath);
        Assert.assertEquals((Object)projectType, (Object)ProjectType.CASE);
    }

    @Test
    public void getProjectTypeNull() {
        Mockito.when((Object)this.directoryStream.spliterator()).thenReturn(Collections.emptyList().spliterator());
        ProjectType projectType = this.tested.getProjectType(this.projectPath);
        Assert.assertEquals((Object)projectType, null);
    }
}

