/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses.SubProcessTest;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EventSubprocessExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class EventSubProcessTest
extends SubProcessTest<EventSubprocess> {
    private static final String BPMN_SUB_PROCESS_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/eventSubProcesses.bpmn";
    private static final String TOP_LEVEL_EMPTY_SUBPROCESS_ID = "_BFAB4FD7-E901-466E-A628-D22047469503";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_ID = "_C331C78A-65AC-46B4-A423-3CF3574372BA";
    private static final String SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID = "_51FEAA5A-43FF-4EC4-8770-33A54BA98A6B";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_ID = "_6A441CA4-0E47-4C84-8473-33F274DEF547";
    private static final String TOP_LEVEL_SUBPROCESS_WITH_EDGES = "_FCB7D840-3B83-4E34-A9DC-C5C0F6C790CB";
    private static final String SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES = "_CFA473E5-6CEC-4DE8-A387-F76E49A5FF00";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 17;
    private static final String SLA_DUE_DATE = "12/25/1983";

    @Override
    @Test
    public void testMarshallTopLevelSubProcessWithEdges() {
        this.checkSubProcessMarshalling(this.getTopLevelSubProcessWithEdgesId(), 1, 4);
    }

    @Override
    @Test
    public void testMarshallSubProcessLevelSubProcessWithEdges() {
        this.checkSubProcessMarshalling(this.getSubProcessLevelSubProcessWithEdgesId(), 1, 4);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 17);
        EventSubprocess topLevelSubProcess = (EventSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), "", "");
        this.assertEventSubProcessExecutionSet(topLevelSubProcess.getExecutionSet(), false, "");
        this.assertSubProcessProcessData(topLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME = "Event process01 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION = "Event process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_VARIABLES = "subVarString:String:false,subVarCustom:Custom:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 17);
        EventSubprocess topLevelSubProcessJava = (EventSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJava.getGeneral(), "Event process01 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Event process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEventSubProcessExecutionSet(topLevelSubProcessJava.getExecutionSet(), true, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessJava.getProcessData(), "subVarString:String:false,subVarCustom:Custom:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Event Sub-process";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 17);
        EventSubprocess topLevelSubProcess = (EventSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_SUBPROCESS_WITH_EDGES, 1, 4);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), "Event Sub-process", "");
        this.assertEventSubProcessExecutionSet(topLevelSubProcess.getExecutionSet(), false, "");
        this.assertSubProcessProcessData(topLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 17);
        EventSubprocess subProcessLevelSubProcess = (EventSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), "", "");
        this.assertEventSubProcessExecutionSet(subProcessLevelSubProcess.getExecutionSet(), false, "");
        this.assertSubProcessProcessData(subProcessLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME = "Event process02 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION = "Event process02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_VARIABLES = "subVarString:String:false,subVarCustom:Custom:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 17);
        EventSubprocess subProcessLevelSubProcessJava = (EventSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJava.getGeneral(), "Event process02 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Event process02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEventSubProcessExecutionSet(subProcessLevelSubProcessJava.getExecutionSet(), true, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessJava.getProcessData(), "subVarString:String:false,subVarCustom:Custom:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Event Sub-process";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 17);
        EventSubprocess subProcessLevelSubProcess = (EventSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES, 1, 4);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), "Event Sub-process", "");
        this.assertEventSubProcessExecutionSet(subProcessLevelSubProcess.getExecutionSet(), false, "");
        this.assertSubProcessProcessData(subProcessLevelSubProcess.getProcessData(), "");
    }

    @Override
    Class<EventSubprocess> getSubProcessType() {
        return EventSubprocess.class;
    }

    @Override
    String getBpmnSubProcessFilePath() {
        return BPMN_SUB_PROCESS_FILE_PATH;
    }

    @Override
    String getTopLevelEmptyPropertiesSubProcessId() {
        return TOP_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getTopLevelFilledPropertiesSubProcessesIds() {
        return new String[]{TOP_LEVEL_FILLED_SUBPROCESS_ID};
    }

    @Override
    String getTopLevelSubProcessWithEdgesId() {
        return TOP_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    @Override
    String getSubProcessLevelEmptyPropertiesSubProcessId() {
        return SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getSubProcessLevelFilledPropertiesSubProcessesIds() {
        return new String[]{SUBPROCESS_LEVEL_FILLED_SUBPROCESS_ID};
    }

    @Override
    String getSubProcessLevelSubProcessWithEdgesId() {
        return SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    private void assertEventSubProcessExecutionSet(EventSubprocessExecutionSet executionSet, boolean isAsync, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getIsAsync()).isNotNull();
        Assertions.assertThat((Boolean)executionSet.getIsAsync().getValue()).isEqualTo(isAsync);
        Assertions.assertThat((Object)executionSet.getSlaDueDate()).isNotNull();
        Assertions.assertThat((String)executionSet.getSlaDueDate().getValue()).isEqualTo((Object)slaDueDate);
    }
}

