/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.indexing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.DefaultResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindAllChangeImpactQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindResourcesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.refactoring.service.impact.QueryOperationRequest;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.bpmn.backend.query.AbstractFindIdsQuery;
import org.kie.workbench.common.stunner.bpmn.backend.query.FindBpmnProcessIdsQuery;
import org.kie.workbench.common.stunner.bpmn.backend.service.indexing.TestBpmnFileIndexer;
import org.kie.workbench.common.stunner.bpmn.resource.BPMNDefinitionSetResourceType;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

public class BpmnFileIndexerTest
extends BaseIndexingTest<BPMNDefinitionSetResourceType> {
    private static final List<String> PROCESS_IDS = Arrays.asList("hiring", "ParentProcess", "SubProcess", "multiple-rule-tasks", "org.jbpm.signal", "org.jbpm.broken");
    private static final String[] BPMN_FILES = new String[]{"callActivity.bpmn", "callActivityByName.bpmn", "callActivityCalledSubProcess.bpmn", "hiring.bpmn", "multipleRuleTasksWithDataInput.bpmn", "signal.bpmn", "brokenSignal.bpmn"};
    private static final String DEPLOYMENT_ID = "org.kjar:test:1.0";
    private static final long WAIT_TIME_MILLIS = 2000L;
    private static final int MAX_WAIT_TIMES = 8;

    protected Set<NamedQuery> getQueries() {
        return new HashSet<NamedQuery>(){
            {
                this.add(new FindResourcesQuery(){

                    public ResponseBuilder getResponseBuilder() {
                        return new DefaultResponseBuilder(BpmnFileIndexerTest.this.ioService());
                    }
                });
                this.add(new FindAllChangeImpactQuery(){

                    public ResponseBuilder getResponseBuilder() {
                        return new DefaultResponseBuilder(BpmnFileIndexerTest.this.ioService());
                    }
                });
                this.add(new FindBpmnProcessIdsQuery(){

                    public ResponseBuilder getResponseBuilder() {
                        return new AbstractFindIdsQuery.BpmnProcessIdsResponseBuilder(BpmnFileIndexerTest.this.ioService(), this.getProcessIdResourceType());
                    }
                });
            }
        };
    }

    @Test
    public void testBpmnIndexing() throws Exception {
        List response;
        ArrayList<Path> pathList = new ArrayList<Path>();
        this.ioService().startBatch(this.ioService().getFileSystem(this.basePath.toUri()));
        for (int i = 0; i < BPMN_FILES.length; ++i) {
            String bpmnFile = BPMN_FILES[i];
            if (!bpmnFile.endsWith("bpmn")) continue;
            Path path = this.basePath.resolve(bpmnFile);
            pathList.add(path);
            String bpmnStr = this.loadText(bpmnFile);
            this.ioService().write(path, bpmnStr, new OpenOption[0]);
        }
        this.ioService().endBatch();
        Path[] paths = pathList.toArray(new Path[pathList.size()]);
        PageResponse<RefactoringPageRow> response2 = null;
        try {
            for (int i = 0; i < 8; ++i) {
                Thread.sleep(2000L);
                response2 = this.queryBPMN2Resources();
                if (response2 == null || response2.getPageRowList() == null || response2.getPageRowList().size() < paths.length) {
                    continue;
                }
                break;
            }
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        Assert.assertNotNull(response2);
        Assert.assertEquals((long)paths.length, (long)response2.getPageRowList().size());
        QueryOperationRequest request = (QueryOperationRequest)QueryOperationRequest.referencesSharedPart((String)"*", (PartType)PartType.RULEFLOW_GROUP, (ValueIndexTerm.TermSearchType)ValueIndexTerm.TermSearchType.WILDCARD).inAllModules().onAllBranches();
        try {
            response = this.service.queryToList(request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)1L, (long)response.size());
            this.assertResponseContains(response, paths[4]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        request = (QueryOperationRequest)QueryOperationRequest.referencesSharedPart((String)"MySignal", (PartType)PartType.SIGNAL).inAllModules().onAllBranches();
        try {
            response = this.service.queryToList(request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)1L, (long)response.size());
            this.assertResponseContains(response, paths[5]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        request = (QueryOperationRequest)QueryOperationRequest.referencesSharedPart((String)"BrokenSignal", (PartType)PartType.SIGNAL).inAllModules().onAllBranches();
        try {
            response = this.service.queryToList(request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)1L, (long)response.size());
            this.assertResponseContains(response, paths[6]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        request = (QueryOperationRequest)QueryOperationRequest.referencesSharedPart((String)"name", (PartType)PartType.GLOBAL).inAllModules().onAllBranches();
        try {
            response = this.service.queryToList(request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)2L, (long)response.size());
            this.assertResponseContains(response, paths[5]);
            this.assertResponseContains(response, paths[6]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueResourceIndexTerm("*", ResourceType.BPMN2, ValueIndexTerm.TermSearchType.WILDCARD));
            }
        };
        try {
            response = this.service.query(FindBpmnProcessIdsQuery.NAME, (Set)queryTerms);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)paths.length, (long)response.size());
            for (String expectedId : PROCESS_IDS) {
                boolean foundId = false;
                for (RefactoringPageRow row : response) {
                    Map mapRow = (Map)row.getValue();
                    for (String rKey : mapRow.keySet()) {
                        Assert.assertTrue((boolean)PROCESS_IDS.contains(rKey));
                        foundId = true;
                    }
                }
                if (foundId) continue;
                Assert.fail((String)("Process with PARENT_ID <" + expectedId + " not found in results for " + FindBpmnProcessIdsQuery.NAME));
            }
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
    }

    private PageResponse<RefactoringPageRow> queryBPMN2Resources() throws IllegalArgumentException {
        RefactoringPageRequest request = new RefactoringPageRequest(FindResourcesQuery.NAME, (Set)new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueResourceIndexTerm("*", ResourceType.BPMN2, ValueIndexTerm.TermSearchType.WILDCARD));
            }
        }, 0, Integer.valueOf(10));
        return this.service.query(request);
    }

    protected KieModuleService getModuleService() {
        org.uberfire.backend.vfs.Path mockRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)mockRoot.toURI()).thenReturn((Object)"/a/mock/module/root");
        KieModule mockModule = (KieModule)Mockito.mock(KieModule.class);
        Mockito.when((Object)mockModule.getRootPath()).thenReturn((Object)mockRoot);
        Mockito.when((Object)mockModule.getModuleName()).thenReturn((Object)"mock-module");
        POM mockPom = (POM)Mockito.mock(POM.class);
        Mockito.when((Object)mockModule.getPom()).thenReturn((Object)mockPom);
        GAV mockGAV = (GAV)Mockito.mock(GAV.class);
        Mockito.when((Object)mockPom.getGav()).thenReturn((Object)mockGAV);
        Mockito.when((Object)mockGAV.toString()).thenReturn((Object)DEPLOYMENT_ID);
        Package mockPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)mockPackage.getPackageName()).thenReturn((Object)"org.kie.workbench.mock.package");
        KieModuleService mockModuleService = (KieModuleService)Mockito.mock(KieModuleService.class);
        Mockito.when((Object)mockModuleService.resolveModule((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)mockModule);
        Mockito.when((Object)mockModuleService.resolvePackage((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)mockPackage);
        return mockModuleService;
    }

    protected TestIndexer getIndexer() {
        return new TestBpmnFileIndexer();
    }

    protected BPMNDefinitionSetResourceType getResourceTypeDefinition() {
        return new BPMNDefinitionSetResourceType();
    }

    protected String getRepositoryName() {
        return this.testName.getMethodName();
    }
}

